#!/bin/sh
# Add triggers for opt mode
# 01/30/03 Fernando Castano-  created

if [ "$ORACLE_HOME" = "" ]
then
	echo "$ORACLE_HOME"
	echo "You must set the ORACLE_HOME environment variable"
	exit 1
fi

if [ $# -ne 2 ]
then
	echo "Usage: schema_X.sh <database_name> <database dir>"
	exit 1
fi

DB=$1
DB_DIR=$2
ORACLE_SID=$DB
export ORACLE_SID


##############################################
#  add triggers 
##############################################
echo "Adding triggers"
sqlplus  /nolog <<EOT 
CONNECT spec/spec 
@sql/schema_addtrigger
EOT

