#!/bin/sh
#

if [ $# -ne 1 ]
then
	echo "Usage: createdb.sh <database dir>"
	exit 1
fi

if [ "$ORACLE_HOME" = "" ]
then
	echo "$ORACLE_HOME"
	echo "You must set the ORACLE_HOME environment variable"
	exit 1
fi

if [ "$ORACLE_SID" = "" ]
then
	echo "$ORACLE_SID"
	echo "You must set the ORACLE_SID environment variable"
	exit 1
fi

####################
# Set the database and database directory vars
#####################
DB=${ORACLE_SID}
DB_DIR=$1


######  datafiles #####
COMP=${DB_DIR}/S_comp
SC=${DB_DIR}/S_suppcomp
SITE=${DB_DIR}/S_site
SUPP=${DB_DIR}/S_supp
PO=${DB_DIR}/S_po

#sqlplus <<EOT  
#CONNECT / as sysdba
#shutdown
#startup 
#EOT

sqlplus <<EOT 
CONNECT / as sysdba

DROP TABLESPACE S_comp_space INCLUDING CONTENTS;
DROP TABLESPACE S_sc_space INCLUDING CONTENTS;
DROP TABLESPACE S_po_space INCLUDING CONTENTS;
DROP TABLESPACE S_site_space INCLUDING CONTENTS;
DROP TABLESPACE S_supp_space INCLUDING CONTENTS;

CREATE TABLESPACE S_comp_space
	DATAFILE '${COMP}' SIZE 990M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
CREATE TABLESPACE S_sc_space
	DATAFILE '${SC}' SIZE 990M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
CREATE TABLESPACE S_po_space
	DATAFILE '${PO}' SIZE 990M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
CREATE TABLESPACE S_site_space
	DATAFILE '${SITE}' SIZE 990M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
CREATE TABLESPACE S_supp_space
	DATAFILE '${SUPP}' SIZE 990M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
EXIT
EOT

wait

##############################################
# Running scripts to create schema and indexes
##############################################
sqlplus spec/spec <<EOT
@sql/schema_S
EOT
