#include <stdio.h>
#include <unistd.h>
#include <sched.h>
#include <sys/types.h>

main(int argc, char *argv[])
{
        struct sched_param sp;
        int i;

        if (argc < 4) {
                fprintf(stderr, "usage: %s -p <prio> pid...\n", argv[0]);
                exit(-1);
        }

        if (!strcmp("-p", argv[1])) {
                sp.sched_priority = atoi(argv[2]);
        }

        for (i = 3; i < argc; i++) {
                pid_t pid = atoi(argv[i]);
                if (sched_setscheduler(pid, SCHED_RR, &sp) == -1) {
                        perror("sched_setscheduler");
                        exit(-1);
                }
        }

        exit(0);
}

