#!/bin/sh
#

if [ $# -ne 1 ]
then
	echo "Usage: createdb.sh <database dir>"
	exit 1
fi

if [ "$ORACLE_HOME" = "" ]
then
	echo "$ORACLE_HOME"
	echo "You must set the ORACLE_HOME environment variable"
	exit 1
fi

if [ "$ORACLE_SID" = "" ]
then
	echo "$ORACLE_SID"
	echo "You must set the ORACLE_SID environment variable"
	exit 1
fi

####################
# Set the database and database directory vars
#####################
DB=${ORACLE_SID}
DB_DIR=$1

######  datafiles #####
# PART=${DB_DIR}/M_parts
# BOM=${DB_DIR}/M_bom
# WO=${DB_DIR}/M_wrkorder
# LO=${DB_DIR}/M_lrgorder
# INV=${DB_DIR}/M_inv

# new pointers for SPECJAppServer2004 on HP-UX Itanium 5/2/05 smc

PART=/dev/rax/raw15
BOM=/dev/rax/raw16
WO=/dev/rax/raw17
LO=/dev/rax/raw18
INV=/dev/rax/raw19
INVA=/dev/rax/raw19a

#sqlplus <<EOT  
#CONNECT / as sysdba
#shutdown
#startup 
#EOT

sqlplus <<EOT 
CONNECT / as sysdba
DROP TABLESPACE M_parts_space INCLUDING CONTENTS;
DROP TABLESPACE M_bom_space INCLUDING CONTENTS;
DROP TABLESPACE M_wo_space INCLUDING CONTENTS;
DROP TABLESPACE M_lo_space INCLUDING CONTENTS;
DROP TABLESPACE M_inv_space INCLUDING CONTENTS;

CREATE TABLESPACE M_parts_space
	DATAFILE '${PART}' SIZE 1990M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
CREATE TABLESPACE M_bom_space
	DATAFILE '${BOM}' SIZE 1990M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
CREATE TABLESPACE M_wo_space
	DATAFILE '${WO}' SIZE 4500M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
CREATE TABLESPACE M_lo_space
	DATAFILE '${LO}' SIZE 1990M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 10M SEGMENT SPACE MANAGEMENT AUTO;
CREATE TABLESPACE M_inv_space
	DATAFILE '${INV}' SIZE 1990M REUSE
	EXTENT MANAGEMENT LOCAL UNIFORM SIZE 5M SEGMENT SPACE MANAGEMENT AUTO;
alter TABLESPACE M_inv_space add datafile '${INVA}' SIZE 3990M REUSE;
EXIT
EOT

wait

##############################################
# Running scripts to create schema and indexes
##############################################
sqlplus spec04/spec04 <<EOT
@sql04/schema_M
EOT
