#!/bin/sh
#
# Copyright (c) 2004, Oracle Corporation.  All rights reserved.
#
# sqlldr.sh:  Flat file loader for Oracle.
#
# April 2004	Melissa Hao	Wrote first version.



DATA_DIR=$1


# A function to load a table.

load_table()
{
  sqlplus spec/spec >> output/sqlldr.log << EOT
  truncate table $1;
EOT

  # sqlldr expects data file to end in .dat
  ls -1 $DATA_DIR/$1/ | grep -v .dat | xargs -i# cp $DATA_DIR/$1/# $DATA_DIR/$1/#.dat
  
  datafiles=`ls $DATA_DIR/$1 | grep .dat`
  for datafile in $datafiles
  do
    #echo Start $datafile.
    sqlldr parallel=true direct=false userid=spec/spec errors=0 \
  	     control=ctl_files/$1 data=$DATA_DIR/$1/$datafile \
	     bad=output/$datafile.bad discard=output/$datafile.discard \
             log=output/$datafile.log >> output/sqlldr.log &
    #echo Done $datafile.
  done
  
  if [ $? -eq 0 ]
  then
    echo "Loaded $1 sucessfully."
  else
    echo "Error loading $1."
  fi
}

# --------------------------------------------------------

### Check parameters.

if [ $# -ne 1 ]
then
  echo "Usage:  sqlldr.sh <datafile dir>"
  exit 1
fi

if [ "$ORACLE_HOME" = "" ]
then
  echo "You must set the ORACLE_HOME environment variable."
  exit 1
fi

if [ "$ORACLE_SID" = "" ]
then
  echo "You must set the ORACLE_SID environment variable."
  exit 1
fi


### Create the output directory if it doesn't already exist.

if [ ! -s output ]
then
  mkdir output
else
  rm output/*
fi


### Load the tables.

load_table c_customer
load_table c_customerinventory
load_table c_parts
load_table c_site
load_table c_supplier
load_table m_bom
load_table m_inventory
load_table m_parts
load_table m_workorder
load_table o_item
load_table o_orderline
load_table o_orders
load_table s_component
load_table s_purchase_order
load_table s_purchase_orderline
load_table s_site
load_table s_supp_component
load_table s_supplier
load_table u_sequences
