SPEC=/specdb/wlsspec

sqlplus "/as sysdba" << !
CREATE TABLESPACE spec_ts
       DATAFILE '+dg_1' SIZE 4096M REUSE
       EXTENT MANAGEMENT LOCAL UNIFORM SIZE 1M;
!

for x in 0 1 2 3
do
 for y in 1 2 3 4
 do
 sqlplus "spec04/spec04" << EOT
spool WL_LLR_JASNODE${x}_${y}_JASSERVER_${y}
alter table WL_LLR_JASNODE${x}_${y}_JASSERVER_${y} enable table lock;
drop table WL_LLR_JASNODE${x}_${y}_JASSERVER_${y} ;
CREATE TABLE WL_LLR_JASNODE${x}_${y}_JASSERVER_${y}
    (
    XIDSTR  VARCHAR2(40) not null,
    POOLNAMESTR VARCHAR2(64),
    RECORDSTR VARCHAR2(1000)
    )
    PARTITION BY HASH (XIDSTR)
    PARTITIONS 43
    STORE IN (SPEC_TS)
    initrans 30 pctfree 30
    STORAGE (INITIAL 1M NEXT 1M PCTINCREASE 0 BUFFER_POOL KEEP);

CREATE UNIQUE INDEX WL_LLR_JASNODE_${x}_${y}_idx ON WL_LLR_JASNODE${x}_${y}_JASSERVER_${y} (xidstr) LOCAL
    STORE IN (SPEC_TS)
    INITRANS 30
    STORAGE (INITIAL 1M NEXT 1M PCTINCREASE 0 BUFFER_POOL KEEP);

alter table WL_LLR_JASNODE${x}_${y}_JASSERVER_${y} disable table lock;
spool off
EOT
 done
done
