SPEC=/specdb/wlsspec

for x in 1 2 3 4 5 6 7
do
sqlplus "spec04/spec04" << EOT
spool WL_LLR_APPZONE${x}_JASSERVER_${x}
alter table WL_LLR_APPZONE${x}_JASSERVER_${x} enable table lock;
drop table WL_LLR_APPZONE${x}_JASSERVER_${x} ;
CREATE TABLE WL_LLR_APPZONE${x}_JASSERVER_${x}
    (
    XIDSTR  VARCHAR2(40) not null,
    POOLNAMESTR VARCHAR2(64),
    RECORDSTR VARCHAR2(1000)
    )
    PARTITION BY HASH (XIDSTR)
    PARTITIONS 43
    STORE IN (SPEC_TS)
    initrans 30 pctfree 30
    STORAGE (INITIAL 1M NEXT 1M PCTINCREASE 0 BUFFER_POOL KEEP);

    CREATE UNIQUE INDEX WL_LLR_APPZONE${x}_idx ON WL_LLR_APPZONE${x}_JASSERVER_${x} (xidstr) LOCAL
    STORE IN (SPEC_TS)
    INITRANS 30
    STORAGE (INITIAL 1M NEXT 1M PCTINCREASE 0 BUFFER_POOL KEEP);

    alter table WL_LLR_APPZONE${x}_JASSERVER_${x} disable table lock;
spool off
EOT
done
