#!/bin/ksh
#dd if=/dev/zero of=/dev/rloglv bs=4096k count=21

#############################################
# REGISTRY VARIABLE TUNING                  #
#############################################

db2set DB2_APM_PERFORMANCE=ON
db2set DB2_KEEPTABLELOCK=ON
db2set DB2SPINLATCHES=/home/db2inst3/scripts/new_spin.config

db2set DB2_USE_ALTERNATE_PAGE_CLEANING=ON
#db2set DB2_PARALLEL_IO=*

#############################################
# DATABASE MANAGER CONFIGURATION TUNING     #
#############################################

#db2 -v update dbm cfg using DIAGLEVEL 1
#db2 -v update dbm cfg using NOTIFYLEVEL 1
#db2 -v update dbm cfg using ASLHEAPSZ 2000 #size of requests don't change with IR
db2 -v update dbm cfg using DFT_MON_BUFPOOL on DFT_MON_LOCK on DFT_MON_SORT off DFT_MON_STMT off DFT_MON_TIMESTAMP on DFT_MON_UOW on DFT_MON_TABLE off 
db2 -v update dbm cfg using CPUSPEED -1
db2 -v update dbm cfg using SVCENAME 60004

db2 -v connect to specdb

############################################
# DATABASE CONFIGURATION TUNING            #
############################################

#db2 -v update db cfg for specdb using DFT_QUERYOPT 1
#db2 -v update db cfg for specdb using DFT_DEGREE 1
db2 -v update db cfg for specdb using LOGBUFSZ 4096
db2 -v update db cfg for specdb using LOGPRIMARY 52
db2 -v update db cfg for specdb using SOFTMAX 1000
db2 -v update db cfg for specdb using CHNGPGS_THRESH 99
db2 -v update db cfg for specdb using LOGFILSIZ 65535 
#db2 -v update db cfg for specdb using LOGRETAIN on
db2 -v update db cfg for specdb using LOGSECOND 0
db2 -v update db cfg for specdb using LOGPRIMARY 52 
db2 -v update db cfg for specdb using NEWLOGPATH /dev/speclogs/speclogLV 
db2 -v update db cfg for specdb using AUTO_MAINT off
db2 -v update db cfg for specdb using AUTO_RUNSTATS off
db2 -v update db cfg for specdb using AUTO_TBL_MAINT off
db2 -v update db cfg for specdb using NUM_IOCLEANERS 24
db2 -v update db cfg for specdb using NUM_IOSERVERS 4
#db2 -v update db cfg for specdb using MAXAPPLS 16800
#db2 -v update db cfg for specdb using AVG_APPLS 16800
db2 -v update db cfg for specdb using LOCKLIST 18000 MAXLOCKS 100
db2 -v update db cfg for specdb using MINCOMMIT 2 
db2 -v update db cfg for specdb using MON_REQ_METRICS none
db2 -v update db cfg for specdb using MON_ACT_METRICS none
db2 -v update db cfg for specdb using MON_OBJ_METRICS none
db2 -v update db cfg for specdb using AUTO_STMT_STATS off
 
 
############################################
# BUFFER POOL TUNING                       #
############################################

db2 -v alter bufferpool IBMDEFAULTBP immediate size 12000000
db2 -v alter bufferpool JMS_BP immediate size 45000

############################################
# TABLE TUNING                             #
############################################

db2 -v alter table O_ORDERLINE append on
db2 -v alter table O_CUSTINVENTORY append on
db2 -v alter table O_ORDERS append on
db2 -v alter table S_PURCH_ORDER append on
db2 -v alter table M_WORKORDER append on
db2 -v alter table M_WORKORDER volatile
db2 -v alter table O_ITEM volatile
db2 -v alter table M_PARTS volatile 
db2 -v alter table M_INVENTORY volatile 

db2 -v terminate
db2set DB2COMM=TCPIP
db2stop force
#dd if=/dev/zero of=/dev/rloglv bs=4096k count=21
db2start
