DROP TABLE M_INVENTORY;
CREATE TABLE M_INVENTORY
(
   IN_P_ID        char(20) not null,
   IN_QTY         integer,
   IN_ORDERED     integer,
   IN_LOCATION    integer not null,
   IN_ACC_CODE    integer,
   IN_ACT_DATE    timestamp,
   IN_VERSION     integer default 0
)
PARTITION BY RANGE (IN_P_ID)
(
   STARTING FROM ('00001ABLEA0000000000') ENDING AT ('00001ANTIA0001100000'),
   STARTING FROM ('00001ATION0000000000') ENDING AT ('00001BARAA0001100000'),
   STARTING FROM ('00001CALLY0000000000') ENDING AT ('00001EINGA0001100000'),
   STARTING FROM ('00001ESEAA0000000000') ENDING AT ('00001IRESE0001100000'),
   STARTING FROM ('00001LINES0000000000') ENDING AT ('00001MITEM0001100000'),
   STARTING FROM ('00001NAILS0000000000') ENDING AT ('00001OUGHT0001100000'),
   STARTING FROM ('00001PRESA0000000000') ENDING AT ('00001QUIET0001100000'),
   STARTING FROM ('00001SCREW0000000000') ENDING AT ('00001SHARE0001100000')
);
DROP INDEX M_INV_IDX;
CREATE UNIQUE INDEX M_INV_IDX ON M_INVENTORY (IN_LOCATION, IN_P_ID) PARTITIONED;

DROP TABLE M_PARTS;
CREATE TABLE M_PARTS
(
        P_ID           char(20) not null,
        P_NAME         char(35),
        P_DESC         varchar(100),
        P_REV          char(6),
        P_PLANNER      integer,
        P_TYPE         integer,
        P_IND          integer,
        P_LOMARK                         integer,
        P_HIMARK       integer,
        P_VERSION      integer default 0
)
PARTITION BY RANGE (P_ID)
(
   STARTING FROM ('00001ABLEA0000000000') ENDING AT ('00001ANTIA0001100000'),
   STARTING FROM ('00001ATION0000000000') ENDING AT ('00001BARAA0001100000'),
   STARTING FROM ('00001CALLY0000000000') ENDING AT ('00001EINGA0001100000'),
   STARTING FROM ('00001ESEAA0000000000') ENDING AT ('00001IRESE0001100000'),
   STARTING FROM ('00001LINES0000000000') ENDING AT ('00001MITEM0001100000'),
   STARTING FROM ('00001NAILS0000000000') ENDING AT ('00001OUGHT0001100000'),
   STARTING FROM ('00001PRESA0000000000') ENDING AT ('00001QUIET0001100000'),
   STARTING FROM ('00001SCREW0000000000') ENDING AT ('00001SHARE0001100000')
);
DROP INDEX M_PARTS_IDX;
CREATE UNIQUE INDEX M_PARTS_IDX ON M_PARTS (P_ID) PARTITIONED;
