#!/bin/sh
#
# Script to create oracle database

if [ $# -ne 1 ]
then
        echo "Usage: `basename $0` <database dir>"
        exit 1
fi

if [ "$ORACLE_HOME" = "" ]
then
        echo "$ORACLE_HOME"
        echo "You must set the ORACLE_HOME environment variable"
        exit 1
fi

if [ "$ORACLE_SID" = "" ]
then
        echo "$ORACLE_SID"
        echo "You must set the ORACLE_SID environment variable"
        exit 1
fi

####################
# Set the database and database directory vars
#####################
DB=${ORACLE_SID}
DB_DIR=$1

####################################
# Check to see that the target database directory
# exists and has write permission.
####################################
if [ ! -d "$DB_DIR" ]
then
        echo "$DB_DIR does not exist. Please create it first."
        exit 1
fi

DB_DIR="+REDO"
LOG1=${DB_DIR}/log1_1
LOG2=${DB_DIR}/log1_2
LOG3=${DB_DIR}/log2_1
LOG4=${DB_DIR}/log2_2
LOGSZ="800000M"

sqlplus "/ as sysdba" <<!
spool addlog.log;
alter database add logfile THREAD 1 GROUP 1 '${LOG1}' size ${LOGSZ} reuse;
alter database add logfile THREAD 1 GROUP 2 '${LOG2}' size ${LOGSZ} reuse;
alter database add logfile THREAD 2 GROUP 3 '${LOG3}' size ${LOGSZ} reuse;
alter database add logfile THREAD 2 GROUP 4 '${LOG4}' size ${LOGSZ} reuse;
exit;
!

