-- The column ordering here and in the loader (LoadManufacturing.java) must match, 
-- so that flat file generation properly maps to columns

DROP TABLE M_PARTS;
DROP CLUSTER MPARTS_CLUSTER including tables;

CREATE CLUSTER MPARTS_CLUSTER ( p_id char(20) )
TABLESPACE M_PARTS_SPACE
STORAGE (PCTINCREASE 0)
HASHKEYS  1000000
SIZE 200;
 
CREATE TABLE M_PARTS
(
   P_ID           char(20) not null,
   P_NAME         char(35),
   P_DESC         varchar(100),
   P_REV          char(6),
   P_PLANNER      integer,
   P_TYPE         integer,
   P_IND          integer,
   P_LOMARK       integer,
   P_HIMARK       integer,
   P_VERSION      integer default 0
)
CLUSTER MPARTS_CLUSTER (p_id );

CREATE UNIQUE INDEX M_PARTS_IDX ON M_PARTS (P_ID)
TABLESPACE M_parts_space
INITRANS 10
STORAGE (INITIAL 10K NEXT 1K PCTINCREASE 0);


DROP TABLE M_BOM;
DROP CLUSTER MBOM_CLUSTER including tables;

CREATE CLUSTER MBOM_CLUSTER ( B_ASSEMBLY_ID char(20) )
TABLESPACE M_BOM_SPACE
STORAGE (PCTINCREASE 0)
HASHKEYS  1000000
SIZE 200;
 
CREATE TABLE M_BOM
(
   B_COMP_ID      char(20) not null,
   B_ASSEMBLY_ID  char(20) not null,
   B_LINE_NO      integer,
   B_QTY          integer,
   B_OPS          integer,
   B_ENG_CHANGE   char(10),
   B_OPS_DESC     varchar(100),
   B_VERSION      integer default 0
)
CLUSTER MBOM_CLUSTER ( b_assembly_id);

CREATE UNIQUE INDEX M_BOM_IDX ON M_BOM (B_ASSEMBLY_ID, B_COMP_ID, B_LINE_NO)
TABLESPACE M_bom_space
INITRANS 10
STORAGE (INITIAL 10K NEXT 1K PCTINCREASE 0);

DROP TABLE M_WORKORDER;
CREATE TABLE M_WORKORDER
(
   WO_NUMBER      integer not null,
   WO_LOCATION    integer not null,
   WO_O_ID        integer,
   WO_OL_ID       integer,
   WO_STATUS      integer,
   WO_ASSEMBLY_ID char(20),
   WO_ORIG_QTY    integer,
   WO_COMP_QTY    integer,
   WO_DUE_DATE    timestamp,
   WO_START_DATE  timestamp,
   WO_VERSION     integer default 0
)
TABLESPACE M_WO_space
pctfree 50
INITRANS 30
PARTITION BY HASH (wo_location, wo_number)
PARTITIONS 64
STORAGE (INITIAL 1M NEXT 1M PCTINCREASE 0 FREELIST GROUPS 14 FREELISTS 8);

CREATE UNIQUE INDEX M_WO_IDX ON M_WORKORDER (WO_LOCATION, WO_NUMBER)
TABLESPACE M_WO_space
pctfree 40
INITRANS 30
STORAGE (INITIAL 1M NEXT 1M PCTINCREASE 0 FREELIST GROUPS 14 FREELISTS 8) LOCAL;

CREATE INDEX M_WO_OOL_IDX ON M_WORKORDER (WO_LOCATION, WO_O_ID, WO_OL_ID)
TABLESPACE M_WO_space
pctfree 40
INITRANS 30
GLOBAL PARTITION BY HASH (wo_location, wo_o_id, wo_ol_id) PARTITIONS 64
STORAGE (INITIAL 1M NEXT 1M PCTINCREASE 0 FREELIST GROUPS 14 FREELISTS 8);

DROP TABLE M_INVENTORY;
DROP CLUSTER MINV_CLUSTER including tables;

CREATE CLUSTER MINV_CLUSTER ( IN_P_ID char(20) , IN_LOCATION integer) 
TABLESPACE M_inv_space
STORAGE (PCTINCREASE 0 BUFFER_POOL KEEP)
HASHKEYS  34000000
SIZE 100;
 
CREATE TABLE M_INVENTORY
(
   IN_P_ID        char(20) not null,
   IN_QTY         integer,
   IN_ORDERED     integer,
   IN_LOCATION    integer not null,
   IN_ACC_CODE    integer,
   IN_ACT_DATE    timestamp,
   IN_VERSION     integer default 0
)
CLUSTER MINV_CLUSTER (in_p_id, in_location);

CREATE UNIQUE INDEX M_INV_IDX ON M_INVENTORY (IN_LOCATION, IN_P_ID)
TABLESPACE M_inv_space
INITRANS 10
STORAGE (INITIAL 10K NEXT 1K PCTINCREASE 0);

