#!/bin/ksh

LLR="+DATA/wlsllr_spec"

sqlplus "/as sysdba" << !
CREATE BIGFILE TABLESPACE wlsllr_ts
       DATAFILE '${LLR}' SIZE 8196M REUSE
       EXTENT MANAGEMENT LOCAL UNIFORM SIZE 1M;
!
# T4-4-003/4/7/9
for x in 31 32 33 34 41 42 43 44   51 52 53 54  61 62 63 64 ; do
  for y in 1 2 ; do

sqlplus "spec/spec" << EOT
spool WL_LLR_JENT${x}_${y}
alter table WL_LLR_JENT${x}_${y} enable table lock;
drop table WL_LLR_JENT${x}_${y} ;
CREATE TABLE WL_LLR_JENT${x}_${y}
    (
    XIDSTR  VARCHAR2(40) not null,
    POOLNAMESTR VARCHAR2(64),
    RECORDSTR VARCHAR2(1000)
    )
    PARTITION BY HASH (XIDSTR)
    PARTITIONS 32
    STORE IN (wlsllr_ts)
    initrans 30 pctfree 30
    STORAGE (INITIAL 1M NEXT 1M PCTINCREASE 0 BUFFER_POOL KEEP);

    CREATE UNIQUE INDEX WL_LLR_JENT${x}_${y}_idx ON WL_LLR_JENT${x}_${y} (xidstr) LOCAL
    STORE IN (wlsllr_ts)
    INITRANS 30
    STORAGE (INITIAL 1M NEXT 1M PCTINCREASE 0 BUFFER_POOL KEEP);

    alter table WL_LLR_JENT${x}_${y} disable table lock;
spool off
EOT

  done
done
