-- This CLP file was created using DB2LOOK Version "10.1" 
-- Timestamp: Wed Sep 26 13:15:13 2012
-- Database Name: SPECDB         
-- Database Manager Version: DB2/AIX64 Version 10.1.0      
-- Database Codepage: 1208
-- Database Collating Sequence is: SYSTEM_819


CONNECT TO SPECDB;



------------------------------------------------
-- DDL Statements for table "DB2INST1"."S_SUPPLIER"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."S_SUPPLIER"  (
		  "SUPP_ID" INTEGER NOT NULL , 
		  "SUPP_NAME" CHAR(16) , 
		  "SUPP_STREET1" CHAR(20) , 
		  "SUPP_STREET2" CHAR(20) , 
		  "SUPP_CITY" CHAR(20) , 
		  "SUPP_STATE" CHAR(2) , 
		  "SUPP_COUNTRY" CHAR(10) , 
		  "SUPP_ZIP" CHAR(9) , 
		  "SUPP_PHONE" CHAR(16) , 
		  "SUPP_CONTACT" CHAR(25) , 
		  "SUPP_WS_URL" VARCHAR(128) , 
		  "SUPP_REPLY_URL" VARCHAR(128) , 
		  "SUPP_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" INDEX IN "S_S_SPACE" ; 

ALTER TABLE "DB2INST1"."S_SUPPLIER" VOLATILE CARDINALITY;






-- DDL Statements for indexes on Table "DB2INST1"."S_SUPPLIER"

CREATE UNIQUE INDEX "DB2INST1"."S_SUPP_IDX" ON "DB2INST1"."S_SUPPLIER" 
		("SUPP_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."S_RUN_CONFIG"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."S_RUN_CONFIG"  (
		  "NAME" VARCHAR(20) NOT NULL , 
		  "VALUE" INTEGER NOT NULL )   
		 IN "USERSPACE1" INDEX IN "S_R_CONFIG_SPACE" ; 





------------------------------------------------
-- DDL Statements for table "DB2INST1"."U_SEQUENCES"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."U_SEQUENCES"  (
		  "S_ID" VARCHAR(50) NOT NULL , 
		  "S_NEXTNUM" INTEGER )   
		 IN "USERSPACE1" INDEX IN "U_SEQ_SPACE" ; 






-- DDL Statements for indexes on Table "DB2INST1"."U_SEQUENCES"

CREATE UNIQUE INDEX "DB2INST1"."U_S_IDX" ON "DB2INST1"."U_SEQUENCES" 
		("S_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."U_DATASEGMENT"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."U_DATASEGMENT"  (
		  "DS_ID" VARCHAR(100) NOT NULL , 
		  "DS_BLOB" CLOB(1048576) LOGGED NOT COMPACT )   
		 IN "USERSPACE1" INDEX IN "U_DS_SPACE" ; 






-- DDL Statements for indexes on Table "DB2INST1"."U_DATASEGMENT"

CREATE UNIQUE INDEX "DB2INST1"."DS_ID_IDX" ON "DB2INST1"."U_DATASEGMENT" 
		("DS_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."U_LOADER"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."U_LOADER"  (
		  "L_TXRATE" INTEGER , 
		  "L_ITEMCOUNT" INTEGER , 
		  "L_ITEMS_PER_TXRATE" INTEGER , 
		  "L_DBIR" INTEGER , 
		  "L_PARALLELISM" INTEGER , 
		  "L_IS_FF" INTEGER , 
		  "L_FF_DIR" VARCHAR(1000) , 
		  "L_FF_DEL" VARCHAR(10) , 
		  "L_IS_STANDALONE" INTEGER , 
		  "L_DB_DRIVER_CLASS" VARCHAR(512) , 
		  "L_DB_URL" VARCHAR(512) , 
		  "L_DB_USER" VARCHAR(512) , 
		  "L_DB_PASSWORD" VARCHAR(512) , 
		  "L_ROOT_SEED" DECIMAL(19,0) , 
		  "L_STATUS" INTEGER , 
		  "L_STARTED_AT" TIMESTAMP , 
		  "L_ENDED_AT" TIMESTAMP , 
		  "L_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" INDEX IN "U_LOADER_SPACE" ; 






-- DDL Statements for indexes on Table "DB2INST1"."U_LOADER"

CREATE UNIQUE INDEX "DB2INST1"."L_TX_IDX" ON "DB2INST1"."U_LOADER" 
		("L_TXRATE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."U_LOAD_MESSAGE"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."U_LOAD_MESSAGE"  (
		  "LM_ID" INTEGER , 
		  "LM_TEXT" CLOB(1048576) LOGGED NOT COMPACT )   
		 IN "USERSPACE1" INDEX IN "U_L_M_SPACE" ; 






-- DDL Statements for indexes on Table "DB2INST1"."U_LOAD_MESSAGE"

CREATE UNIQUE INDEX "DB2INST1"."LM_ID_IDX" ON "DB2INST1"."U_LOAD_MESSAGE" 
		("LM_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."U_LOAD_SECTION"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."U_LOAD_SECTION"  (
		  "LS_ID" INTEGER , 
		  "LS_DOMAIN" VARCHAR(50) , 
		  "LS_TABLENAMES" VARCHAR(200) , 
		  "LS_SECTION_ID" INTEGER , 
		  "LS_START_STEP" INTEGER , 
		  "LS_NUM_STEPS" INTEGER , 
		  "LS_STATE" INTEGER , 
		  "LS_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" INDEX IN "U_L_S_SPACE" ; 






-- DDL Statements for indexes on Table "DB2INST1"."U_LOAD_SECTION"

CREATE UNIQUE INDEX "DB2INST1"."LS_ID_IDX" ON "DB2INST1"."U_LOAD_SECTION" 
		("LS_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."M_BOM"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."M_BOM"  (
		  "B_COMP_ID" CHAR(20) NOT NULL , 
		  "B_ASSEMBLY_ID" CHAR(20) NOT NULL , 
		  "B_LINE_NO" INTEGER , 
		  "B_QTY" INTEGER , 
		  "B_OPS" INTEGER , 
		  "B_ENG_CHANGE" CHAR(10) , 
		  "B_OPS_DESC" VARCHAR(100) , 
		  "B_VERSION" INTEGER WITH DEFAULT 0 )   
		 INDEX IN "M_BOM_SPACE" PARTITION BY RANGE("B_COMP_ID") 
		 (PART "PART0" STARTING('00001ABLEA0000000000') ENDING('00001ABLEA0001100000') IN "USERSPACE1" INDEX IN "M_BOM_SPACE", 
		 PART "PART1" ENDING('00001ANTIA0001100000') IN "USERSPACE1" INDEX IN "M_BOM_SPACE", 
		 PART "PART2" ENDING('00001ATION0001100000') IN "USERSPACE1" INDEX IN "M_BOM_SPACE", 
		 PART "PART3" ENDING('00001BARAA0001100000') IN "USERSPACE1" INDEX IN "M_BOM_SPACE", 
		 PART "PART4" ENDING('00001CALLY0001100000') IN "USERSPACE1" INDEX IN "M_BOM_SPACE", 
		 PART "PART5" ENDING('00001EINGA0001100000') IN "USERSPACE1" INDEX IN "M_BOM_SPACE", 
		 PART "PART6" ENDING('00001ESEAA0001100000') IN "USERSPACE1" INDEX IN "M_BOM_SPACE", 
		 PART "PART7" ENDING('00001IRESE0001100000') IN "USERSPACE1" INDEX IN "M_BOM_SPACE", 
		 PART "PART8" ENDING('00001LINES0001100000') IN "USERSPACE1" INDEX IN "M_BOM_SPACE", 
		 PART "PART9" ENDING('00001MITEM0001100000') IN "USERSPACE1" INDEX IN "M_BOM_SPACE", 
		 PART "PART10" ENDING('00001NAILS0001100000') IN "USERSPACE1" INDEX IN "M_BOM_SPACE", 
		 PART "PART11" ENDING('00001OUGHT0001100000') IN "USERSPACE1" INDEX IN "M_BOM_SPACE", 
		 PART "PART12" ENDING('00001PRESA0001100000') IN "USERSPACE1" INDEX IN "M_BOM_SPACE", 
		 PART "PART13" ENDING('00001QUIET0001100000') IN "USERSPACE1" INDEX IN "M_BOM_SPACE", 
		 PART "PART14" ENDING('00001SCREW0001100000') IN "USERSPACE1" INDEX IN "M_BOM_SPACE", 
		 PART "PART15" ENDING('00001SHARE0001100000') IN "USERSPACE1" INDEX IN "M_BOM_SPACE"); 






-- DDL Statements for indexes on Table "DB2INST1"."M_BOM"

CREATE UNIQUE INDEX "DB2INST1"."M_BOM_IDX" ON "DB2INST1"."M_BOM" 
		("B_ASSEMBLY_ID" ASC,
		 "B_COMP_ID" ASC,
		 "B_LINE_NO" ASC)
		PARTITIONED
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."S_COMPONENT"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."S_COMPONENT"  (
		  "COMP_ID" CHAR(20) NOT NULL , 
		  "COMP_SITE_ID" INTEGER NOT NULL , 
		  "COMP_NAME" CHAR(10) , 
		  "COMP_DESC" VARCHAR(100) , 
		  "COMP_UNIT" CHAR(10) , 
		  "COMP_COST" DECIMAL(12,2) , 
		  "QTY_ON_ORDER" INTEGER , 
		  "QTY_DEMANDED" INTEGER , 
		  "LEAD_TIME" INTEGER , 
		  "CONTAINER_SIZE" INTEGER , 
		  "COMP_VERSION" INTEGER WITH DEFAULT 0 )   
		 INDEX IN "S_C_SPACE" PARTITION BY RANGE("COMP_ID") 
		 (PART "PART0" STARTING('00001ABLEA0000000000') ENDING('00001ABLEA0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART1" ENDING('00001ANTIA0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART2" ENDING('00001ATION0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART3" ENDING('00001BARAA0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART4" ENDING('00001CALLY0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART5" ENDING('00001EINGA0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART6" ENDING('00001ESEAA0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART7" ENDING('00001IRESE0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART8" ENDING('00001LINES0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART9" ENDING('00001MITEM0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART10" ENDING('00001NAILS0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART11" ENDING('00001OUGHT0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART12" ENDING('00001PRESA0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART13" ENDING('00001QUIET0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART14" ENDING('00001SCREW0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE", 
		 PART "PART15" ENDING('00001SHARE0001100000') IN "USERSPACE1" INDEX IN "S_C_SPACE"); 






-- DDL Statements for indexes on Table "DB2INST1"."S_COMPONENT"

CREATE UNIQUE INDEX "DB2INST1"."S_COMP_IDX" ON "DB2INST1"."S_COMPONENT" 
		("COMP_SITE_ID" ASC,
		 "COMP_ID" ASC)
		PARTITIONED
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."S_SUPP_COMPONENT"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."S_SUPP_COMPONENT"  (
		  "SC_P_ID" CHAR(20) NOT NULL , 
		  "SC_SUPP_ID" INTEGER NOT NULL , 
		  "SC_PRICE" DECIMAL(12,2) , 
		  "SC_QTY" INTEGER , 
		  "SC_DISCOUNT" DECIMAL(6,4) , 
		  "SC_DEL_DATE" INTEGER , 
		  "SC_VERSION" INTEGER WITH DEFAULT 0 )   
		 INDEX IN "S_S_C_SPACE" PARTITION BY RANGE("SC_P_ID") 
		 (PART "PART0" STARTING('00001ABLEA0000000000') ENDING('00001ABLEA0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART1" ENDING('00001ANTIA0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART2" ENDING('00001ATION0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART3" ENDING('00001BARAA0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART4" ENDING('00001CALLY0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART5" ENDING('00001EINGA0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART6" ENDING('00001ESEAA0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART7" ENDING('00001IRESE0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART8" ENDING('00001LINES0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART9" ENDING('00001MITEM0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART10" ENDING('00001NAILS0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART11" ENDING('00001OUGHT0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART12" ENDING('00001PRESA0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART13" ENDING('00001QUIET0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART14" ENDING('00001SCREW0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE", 
		 PART "PART15" ENDING('00001SHARE0001100000') IN "USERSPACE1" INDEX IN "S_S_C_SPACE"); 






-- DDL Statements for indexes on Table "DB2INST1"."S_SUPP_COMPONENT"

CREATE UNIQUE INDEX "DB2INST1"."S_SC_IDX" ON "DB2INST1"."S_SUPP_COMPONENT" 
		("SC_P_ID" ASC,
		 "SC_SUPP_ID" ASC)
		PARTITIONED
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."M_INVENTORY"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."M_INVENTORY"  (
		  "IN_P_ID" CHAR(20) NOT NULL , 
		  "IN_QTY" INTEGER , 
		  "IN_ORDERED" INTEGER , 
		  "IN_LOCATION" INTEGER NOT NULL , 
		  "IN_ACC_CODE" INTEGER , 
		  "IN_ACT_DATE" TIMESTAMP , 
		  "IN_VERSION" INTEGER WITH DEFAULT 0 )   
		 INDEX IN "M_INV_SPACE" PARTITION BY RANGE("IN_P_ID") 
		 (PART "PART0" STARTING('00001ABLEA0000000000') ENDING('00001ABLEA0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART1" ENDING('00001ABLEA0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART2" ENDING('00001ABLEA0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART3" ENDING('00001ABLEA0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART4" ENDING('00001ABLEA0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART5" ENDING('00001ANTIA0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART6" ENDING('00001ANTIA0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART7" ENDING('00001ANTIA0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART8" ENDING('00001ANTIA0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART9" ENDING('00001ANTIA0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART10" ENDING('00001ATION0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART11" ENDING('00001ATION0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART12" ENDING('00001ATION0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART13" ENDING('00001ATION0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART14" ENDING('00001ATION0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART15" ENDING('00001BARAA0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART16" ENDING('00001BARAA0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART17" ENDING('00001BARAA0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART18" ENDING('00001BARAA0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART19" ENDING('00001BARAA0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART20" ENDING('00001CALLY0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART21" ENDING('00001CALLY0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART22" ENDING('00001CALLY0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART23" ENDING('00001CALLY0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART24" ENDING('00001CALLY0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART25" ENDING('00001EINGA0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART26" ENDING('00001EINGA0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART27" ENDING('00001EINGA0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART28" ENDING('00001EINGA0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART29" ENDING('00001EINGA0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART30" ENDING('00001ESEAA0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART31" ENDING('00001ESEAA0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART32" ENDING('00001ESEAA0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART33" ENDING('00001ESEAA0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART34" ENDING('00001ESEAA0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART35" ENDING('00001IRESE0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART36" ENDING('00001IRESE0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART37" ENDING('00001IRESE0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART38" ENDING('00001IRESE0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART39" ENDING('00001IRESE0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART40" ENDING('00001LINES0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART41" ENDING('00001LINES0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART42" ENDING('00001LINES0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART43" ENDING('00001LINES0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART44" ENDING('00001LINES0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART45" ENDING('00001MITEM0000015000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART46" ENDING('00001MITEM0000030000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART47" ENDING('00001MITEM0000045000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART48" ENDING('00001MITEM0000060000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART49" ENDING('00001MITEM0000075000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART50" ENDING('00001NAILS0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART51" ENDING('00001NAILS0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART52" ENDING('00001NAILS0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART53" ENDING('00001NAILS0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART54" ENDING('00001NAILS0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART55" ENDING('00001OUGHT0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART56" ENDING('00001OUGHT0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART57" ENDING('00001OUGHT0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART58" ENDING('00001OUGHT0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART59" ENDING('00001OUGHT0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART60" ENDING('00001PRESA0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART61" ENDING('00001PRESA0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART62" ENDING('00001PRESA0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART63" ENDING('00001PRESA0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART64" ENDING('00001PRESA0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART65" ENDING('00001PRIAA0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART66" ENDING('00001PRIAA0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART67" ENDING('00001PRIAA0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART68" ENDING('00001PRIAA0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART69" ENDING('00001PRIAA0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART70" ENDING('00001QUIET0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART71" ENDING('00001QUIET0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART72" ENDING('00001QUIET0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART73" ENDING('00001QUIET0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART74" ENDING('00001QUIET0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART75" ENDING('00001SCREW0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART76" ENDING('00001SCREW0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART77" ENDING('00001SCREW0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART78" ENDING('00001SCREW0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART79" ENDING('00001SCREW0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART80" ENDING('00001SHARE0000220000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART81" ENDING('00001SHARE0000440000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART82" ENDING('00001SHARE0000660000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART83" ENDING('00001SHARE0000880000') IN "USERSPACE1" INDEX IN "M_INV_SPACE", 
		 PART "PART84" ENDING('00001SHARE0001100000') IN "USERSPACE1" INDEX IN "M_INV_SPACE"); 






-- DDL Statements for indexes on Table "DB2INST1"."M_INVENTORY"

CREATE UNIQUE INDEX "DB2INST1"."M_INV_IDX" ON "DB2INST1"."M_INVENTORY" 
		("IN_LOCATION" ASC,
		 "IN_P_ID" ASC)
		PARTITIONED
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."M_PARTS"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."M_PARTS"  (
		  "P_ID" CHAR(20) NOT NULL , 
		  "P_NAME" CHAR(35) , 
		  "P_DESC" VARCHAR(100) , 
		  "P_REV" CHAR(6) , 
		  "P_PLANNER" INTEGER , 
		  "P_TYPE" INTEGER , 
		  "P_IND" INTEGER , 
		  "P_LOMARK" INTEGER , 
		  "P_HIMARK" INTEGER , 
		  "P_VERSION" INTEGER WITH DEFAULT 0 )   
		 INDEX IN "M_PARTS_SPACE" PARTITION BY RANGE("P_ID") 
		 (PART "PART0" STARTING('00001ABLEA0000000000') ENDING('00001ABLEA0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART1" ENDING('00001ABLEA0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART2" ENDING('00001ABLEA0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART3" ENDING('00001ABLEA0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART4" ENDING('00001ABLEA0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART5" ENDING('00001ANTIA0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART6" ENDING('00001ANTIA0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART7" ENDING('00001ANTIA0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART8" ENDING('00001ANTIA0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART9" ENDING('00001ANTIA0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART10" ENDING('00001ATION0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART11" ENDING('00001ATION0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART12" ENDING('00001ATION0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART13" ENDING('00001ATION0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART14" ENDING('00001ATION0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART15" ENDING('00001BARAA0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART16" ENDING('00001BARAA0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART17" ENDING('00001BARAA0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART18" ENDING('00001BARAA0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART19" ENDING('00001BARAA0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART20" ENDING('00001CALLY0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART21" ENDING('00001CALLY0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART22" ENDING('00001CALLY0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART23" ENDING('00001CALLY0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART24" ENDING('00001CALLY0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART25" ENDING('00001EINGA0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART26" ENDING('00001EINGA0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART27" ENDING('00001EINGA0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART28" ENDING('00001EINGA0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART29" ENDING('00001EINGA0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART30" ENDING('00001ESEAA0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART31" ENDING('00001ESEAA0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART32" ENDING('00001ESEAA0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART33" ENDING('00001ESEAA0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART34" ENDING('00001ESEAA0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART35" ENDING('00001IRESE0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART36" ENDING('00001IRESE0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART37" ENDING('00001IRESE0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART38" ENDING('00001IRESE0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART39" ENDING('00001IRESE0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART40" ENDING('00001LINES0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART41" ENDING('00001LINES0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART42" ENDING('00001LINES0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART43" ENDING('00001LINES0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART44" ENDING('00001LINES0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART45" ENDING('00001MITEM0000015000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART46" ENDING('00001MITEM0000030000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART47" ENDING('00001MITEM0000045000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART48" ENDING('00001MITEM0000060000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART49" ENDING('00001MITEM0000075000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART50" ENDING('00001NAILS0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART51" ENDING('00001NAILS0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART52" ENDING('00001NAILS0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART53" ENDING('00001NAILS0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART54" ENDING('00001NAILS0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART55" ENDING('00001OUGHT0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART56" ENDING('00001OUGHT0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART57" ENDING('00001OUGHT0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART58" ENDING('00001OUGHT0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART59" ENDING('00001OUGHT0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART60" ENDING('00001PRESA0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART61" ENDING('00001PRESA0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART62" ENDING('00001PRESA0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART63" ENDING('00001PRESA0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART64" ENDING('00001PRESA0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART65" ENDING('00001PRIAA0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART66" ENDING('00001PRIAA0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART67" ENDING('00001PRIAA0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART68" ENDING('00001PRIAA0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART69" ENDING('00001PRIAA0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART70" ENDING('00001QUIET0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART71" ENDING('00001QUIET0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART72" ENDING('00001QUIET0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART73" ENDING('00001QUIET0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART74" ENDING('00001QUIET0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART75" ENDING('00001SCREW0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART76" ENDING('00001SCREW0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART77" ENDING('00001SCREW0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART78" ENDING('00001SCREW0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART79" ENDING('00001SCREW0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART80" ENDING('00001SHARE0000220000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART81" ENDING('00001SHARE0000440000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART82" ENDING('00001SHARE0000660000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART83" ENDING('00001SHARE0000880000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE", 
		 PART "PART84" ENDING('00001SHARE0001100000') IN "USERSPACE1" INDEX IN "M_PARTS_SPACE"); 






-- DDL Statements for indexes on Table "DB2INST1"."M_PARTS"

CREATE UNIQUE INDEX "DB2INST1"."M_PARTS_IDX" ON "DB2INST1"."M_PARTS" 
		("P_ID" ASC)
		PARTITIONED
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."O_CUSTOMER"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."O_CUSTOMER"  (
		  "C_ID" INTEGER NOT NULL , 
		  "C_FIRST" CHAR(16) , 
		  "C_LAST" CHAR(16) , 
		  "C_STREET1" CHAR(20) , 
		  "C_STREET2" CHAR(20) , 
		  "C_CITY" CHAR(20) , 
		  "C_STATE" CHAR(2) , 
		  "C_COUNTRY" CHAR(10) , 
		  "C_ZIP" CHAR(9) , 
		  "C_PHONE" CHAR(16) , 
		  "C_CONTACT" CHAR(25) , 
		  "C_SINCE" DATE , 
		  "C_BALANCE" DECIMAL(12,2) , 
		  "C_CREDIT" CHAR(2) , 
		  "C_CREDIT_LIMIT" DECIMAL(12,2) , 
		  "C_YTD_PAYMENT" DECIMAL(12,2) , 
		  "C_VERSION" INTEGER WITH DEFAULT 0 )   
		 INDEX IN "O_CUSTOMER_SPACE" PARTITION BY RANGE("C_ID") 
		 (PART "0" STARTING(0) ENDING(4999999) IN "USERSPACE1" INDEX IN "O_CUSTOMER_SPACE", 
		 PART "1" STARTING(5000000) ENDING(9999999) IN "USERSPACE1" INDEX IN "O_CUSTOMER_SPACE", 
		 PART "2" STARTING(10000000) ENDING(14999999) IN "USERSPACE1" INDEX IN "O_CUSTOMER_SPACE", 
		 PART "3" STARTING(15000000) ENDING(19999999) IN "USERSPACE1" INDEX IN "O_CUSTOMER_SPACE", 
		 PART "4" STARTING(20000000) ENDING(24999999) IN "USERSPACE1" INDEX IN "O_CUSTOMER_SPACE", 
		 PART "5" STARTING(25000000) ENDING(29999999) IN "USERSPACE1" INDEX IN "O_CUSTOMER_SPACE", 
		 PART "6" STARTING(30000000) ENDING(34999999) IN "USERSPACE1" INDEX IN "O_CUSTOMER_SPACE", 
		 PART "7" STARTING(35000000) ENDING(39999999) IN "USERSPACE1" INDEX IN "O_CUSTOMER_SPACE", 
		 PART "8" STARTING(40000000) ENDING(44999999) IN "USERSPACE1" INDEX IN "O_CUSTOMER_SPACE", 
		 PART "9" STARTING(45000000) ENDING(49999999) IN "USERSPACE1" INDEX IN "O_CUSTOMER_SPACE", 
		 PART "10" STARTING(50000000) ENDING(52500000) IN "USERSPACE1" INDEX IN "O_CUSTOMER_SPACE"); 






-- DDL Statements for indexes on Table "DB2INST1"."O_CUSTOMER"

CREATE UNIQUE INDEX "DB2INST1"."O_C_IDX" ON "DB2INST1"."O_CUSTOMER" 
		("C_ID" ASC)
		PARTITIONED
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."O_ITEM"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."O_ITEM"  (
		  "I_ID" CHAR(20) NOT NULL , 
		  "I_NAME" CHAR(35) , 
		  "I_DESC" VARCHAR(100) , 
		  "I_PRICE" DECIMAL(12,2) , 
		  "I_DISCOUNT" DECIMAL(6,4) , 
		  "I_CATEGORY" INTEGER NOT NULL , 
		  "I_VERSION" INTEGER WITH DEFAULT 0 )   
		 INDEX IN "O_ITEM_SPACE" PARTITION BY RANGE("I_ID") 
		 (PART "PART0" STARTING('00001MITEM0000000001') ENDING('00001MITEM0000005000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART1" ENDING('00001MITEM0000010000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART2" ENDING('00001MITEM0000015000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART3" ENDING('00001MITEM0000020000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART4" ENDING('00001MITEM0000025000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART5" ENDING('00001MITEM0000030000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART6" ENDING('00001MITEM0000035000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART7" ENDING('00001MITEM0000040000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART8" ENDING('00001MITEM0000045000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART9" ENDING('00001MITEM0000050000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART10" ENDING('00001MITEM0000055000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART11" ENDING('00001MITEM0000060000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART12" ENDING('00001MITEM0000065000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART13" ENDING('00001MITEM0000070000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART14" ENDING('00001MITEM0000075000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE", 
		 PART "PART15" ENDING('00001MITEM0000080000') IN "USERSPACE1" INDEX IN "O_ITEM_SPACE"); 

ALTER TABLE "DB2INST1"."O_ITEM" VOLATILE CARDINALITY;






-- DDL Statements for indexes on Table "DB2INST1"."O_ITEM"

CREATE INDEX "DB2INST1"."O_ICAT_IDX" ON "DB2INST1"."O_ITEM" 
		("I_CATEGORY" ASC)
		PARTITIONED
		
		COMPRESS NO ALLOW REVERSE SCANS;

-- DDL Statements for indexes on Table "DB2INST1"."O_ITEM"

CREATE UNIQUE INDEX "DB2INST1"."O_I_IDX" ON "DB2INST1"."O_ITEM" 
		("I_ID" ASC)
		PARTITIONED
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."O_CUSTINVENTORY"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."O_CUSTINVENTORY"  (
		  "CI_ID" INTEGER NOT NULL , 
		  "CI_CUSTOMERID" INTEGER NOT NULL , 
		  "CI_ITEMID" CHAR(20) , 
		  "CI_QUANTITY" INTEGER , 
		  "CI_VALUE" DECIMAL(12,2) , 
		  "CI_VERSION" INTEGER WITH DEFAULT 0 )   
		 INDEX IN "O_CI_SPACE" PARTITION BY RANGE("CI_CUSTOMERID") 
		 (PART "0" STARTING(0) ENDING(9999999) IN "DATA_SPACE" INDEX IN "O_CI_SPACE", 
		 PART "1" STARTING(10000000) ENDING(19999999) IN "DATA_SPACE" INDEX IN "O_CI_SPACE", 
		 PART "2" STARTING(20000000) ENDING(29999999) IN "DATA_SPACE" INDEX IN "O_CI_SPACE", 
		 PART "3" STARTING(30000000) ENDING(39999999) IN "DATA_SPACE" INDEX IN "O_CI_SPACE", 
		 PART "4" STARTING(40000000) ENDING(49999999) IN "DATA_SPACE" INDEX IN "O_CI_SPACE", 
		 PART "5" STARTING(50000000) ENDING(59999999) IN "DATA_SPACE" INDEX IN "O_CI_SPACE", 
		 PART "6" STARTING(60000000) ENDING(69999999) IN "DATA_SPACE" INDEX IN "O_CI_SPACE", 
		 PART "7" STARTING(70000000) ENDING(79999999) IN "DATA_SPACE" INDEX IN "O_CI_SPACE", 
		 PART "8" STARTING(80000000) ENDING(89999999) IN "DATA_SPACE" INDEX IN "O_CI_SPACE", 
		 PART "9" STARTING(90000000) ENDING(99999999) IN "DATA_SPACE" INDEX IN "O_CI_SPACE", 
		 PART "10" STARTING(100000000) ENDING(105000000) IN "DATA_SPACE" INDEX IN "O_CI_SPACE"); 






-- DDL Statements for indexes on Table "DB2INST1"."O_CUSTINVENTORY"

CREATE UNIQUE INDEX "DB2INST1"."O_CI_IDX" ON "DB2INST1"."O_CUSTINVENTORY" 
		("CI_CUSTOMERID" ASC,
		 "CI_ID" ASC)
		PARTITIONED
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."O_ORDERS"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."O_ORDERS"  (
		  "O_ID" INTEGER NOT NULL , 
		  "O_C_ID" INTEGER , 
		  "O_OL_CNT" INTEGER , 
		  "O_DISCOUNT" DECIMAL(4,2) , 
		  "O_TOTAL" DECIMAL(12,2) , 
		  "O_STATUS" INTEGER , 
		  "O_ENTRY_DATE" TIMESTAMP , 
		  "O_SHIP_DATE" DATE , 
		  "O_VERSION" INTEGER WITH DEFAULT 0 )   
		 INDEX IN "O_ORDERS_SPACE" PARTITION BY RANGE("O_C_ID") 
		 (PART "0" STARTING(0) ENDING(9999999) IN "DATA_SPACE" INDEX IN "O_ORDERS_SPACE", 
		 PART "1" STARTING(10000000) ENDING(19999999) IN "DATA_SPACE" INDEX IN "O_ORDERS_SPACE", 
		 PART "2" STARTING(20000000) ENDING(29999999) IN "DATA_SPACE" INDEX IN "O_ORDERS_SPACE", 
		 PART "3" STARTING(30000000) ENDING(39999999) IN "DATA_SPACE" INDEX IN "O_ORDERS_SPACE", 
		 PART "4" STARTING(40000000) ENDING(49999999) IN "DATA_SPACE" INDEX IN "O_ORDERS_SPACE", 
		 PART "5" STARTING(50000000) ENDING(52500000) IN "DATA_SPACE" INDEX IN "O_ORDERS_SPACE"); 






-- DDL Statements for indexes on Table "DB2INST1"."O_ORDERS"

CREATE INDEX "DB2INST1"."O_OC_IDX" ON "DB2INST1"."O_ORDERS" 
		("O_C_ID" ASC)
		PARTITIONED
		
		COMPRESS NO ALLOW REVERSE SCANS;

-- DDL Statements for indexes on Table "DB2INST1"."O_ORDERS"

CREATE UNIQUE INDEX "DB2INST1"."O_ORDS_IDX" ON "DB2INST1"."O_ORDERS" 
		("O_ID" ASC)
		NOT PARTITIONED IN "O_ORDERS_SPACE"
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."O_ORDERLINE"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."O_ORDERLINE"  (
		  "OL_ID" INTEGER NOT NULL , 
		  "OL_O_ID" INTEGER NOT NULL , 
		  "OL_I_ID" CHAR(20) , 
		  "OL_QTY" INTEGER , 
		  "OL_TOTAL_VALUE" DECIMAL(12,2) , 
		  "OL_MSRP" DECIMAL(12,2) , 
		  "OL_STATUS" INTEGER , 
		  "OL_SHIP_DATE" TIMESTAMP , 
		  "OL_VERSION" INTEGER WITH DEFAULT 0 )   
		 INDEX IN "O_OL_SPACE" PARTITION BY RANGE("OL_O_ID") 
		 (PART "0" STARTING(0) ENDING(199999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "1" STARTING(200000) ENDING(399999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "2" STARTING(400000) ENDING(599999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "3" STARTING(600000) ENDING(799999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "4" STARTING(800000) ENDING(999999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "5" STARTING(1000000) ENDING(1199999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "6" STARTING(1200000) ENDING(1399999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "7" STARTING(1400000) ENDING(1599999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "8" STARTING(1600000) ENDING(1799999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "9" STARTING(1800000) ENDING(1999999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "10" STARTING(2000000) ENDING(2199999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "11" STARTING(2200000) ENDING(2399999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "12" STARTING(2400000) ENDING(2599999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "13" STARTING(2600000) ENDING(2799999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "14" STARTING(2800000) ENDING(2999999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "15" STARTING(3000000) ENDING(3199999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "16" STARTING(3200000) ENDING(3399999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "17" STARTING(3400000) ENDING(3599999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "18" STARTING(3600000) ENDING(3799999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "19" STARTING(3800000) ENDING(3999999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "20" STARTING(4000000) ENDING(4199999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "21" STARTING(4200000) ENDING(4399999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "22" STARTING(4400000) ENDING(4599999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "23" STARTING(4600000) ENDING(4799999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "24" STARTING(4800000) ENDING(4999999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "25" STARTING(5000000) ENDING(5199999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "26" STARTING(5200000) ENDING(5399999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "27" STARTING(5400000) ENDING(5599999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "28" STARTING(5600000) ENDING(5799999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "29" STARTING(5800000) ENDING(5999999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "30" STARTING(6000000) ENDING(6199999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "31" STARTING(6200000) ENDING(6399999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "32" STARTING(6400000) ENDING(6599999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "33" STARTING(6600000) ENDING(6799999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "34" STARTING(6800000) ENDING(6999999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "35" STARTING(7000000) ENDING(7199999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "36" STARTING(7200000) ENDING(7399999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "37" STARTING(7400000) ENDING(7599999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "38" STARTING(7600000) ENDING(7799999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "39" STARTING(7800000) ENDING(7999999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "40" STARTING(8000000) ENDING(8199999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "41" STARTING(8200000) ENDING(8399999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "42" STARTING(8400000) ENDING(8599999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "43" STARTING(8600000) ENDING(8799999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "44" STARTING(8800000) ENDING(8999999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "45" STARTING(9000000) ENDING(9199999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "46" STARTING(9200000) ENDING(9399999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "47" STARTING(9400000) ENDING(9599999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "48" STARTING(9600000) ENDING(9799999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "49" STARTING(9800000) ENDING(9999999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "50" STARTING(10000000) ENDING(10199999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "51" STARTING(10200000) ENDING(10399999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "52" STARTING(10400000) ENDING(10599999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "53" STARTING(10600000) ENDING(10799999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "54" STARTING(10800000) ENDING(10999999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "55" STARTING(11000000) ENDING(11199999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "56" STARTING(11200000) ENDING(11399999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "57" STARTING(11400000) ENDING(11599999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "58" STARTING(11600000) ENDING(11799999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "59" STARTING(11800000) ENDING(11999999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "60" STARTING(12000000) ENDING(12199999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "61" STARTING(12200000) ENDING(12399999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "62" STARTING(12400000) ENDING(12599999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "63" STARTING(12600000) ENDING(12799999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "64" STARTING(12800000) ENDING(12999999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "65" STARTING(13000000) ENDING(13199999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "66" STARTING(13200000) ENDING(13399999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "67" STARTING(13400000) ENDING(13599999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "68" STARTING(13600000) ENDING(13799999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "69" STARTING(13800000) ENDING(13999999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "70" STARTING(14000000) ENDING(14199999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "71" STARTING(14200000) ENDING(14399999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "72" STARTING(14400000) ENDING(14599999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "73" STARTING(14600000) ENDING(14799999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "74" STARTING(14800000) ENDING(14999999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "75" STARTING(15000000) ENDING(15199999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "76" STARTING(15200000) ENDING(15399999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "77" STARTING(15400000) ENDING(15599999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "78" STARTING(15600000) ENDING(15799999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "79" STARTING(15800000) ENDING(15999999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "80" STARTING(16000000) ENDING(16199999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "81" STARTING(16200000) ENDING(16399999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "82" STARTING(16400000) ENDING(16599999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "83" STARTING(16600000) ENDING(16799999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "84" STARTING(16800000) ENDING(16999999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "85" STARTING(17000000) ENDING(17199999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "86" STARTING(17200000) ENDING(17399999) IN "DATA_SPACE" INDEX IN "O_OL_SPACE", 
		 PART "87" STARTING(17400000) ENDING(17500000) IN "DATA_SPACE" INDEX IN "O_OL_SPACE"); 






-- DDL Statements for indexes on Table "DB2INST1"."O_ORDERLINE"

CREATE UNIQUE INDEX "DB2INST1"."O_ORDL_IDX" ON "DB2INST1"."O_ORDERLINE" 
		("OL_O_ID" ASC,
		 "OL_ID" ASC)
		PARTITIONED
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."S_PURCH_ORDER"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."S_PURCH_ORDER"  (
		  "PO_NUMBER" INTEGER NOT NULL , 
		  "PO_SITE_ID" INTEGER NOT NULL , 
		  "PO_SUPP_ID" INTEGER , 
		  "PO_POPULAR_SUPP" INTEGER , 
		  "PO_START_DATE" TIMESTAMP , 
		  "PO_SENT_DATE" DATE , 
		  "PO_VERSION" INTEGER WITH DEFAULT 0 )   
		 INDEX IN "S_P_O_SPACE" PARTITION BY RANGE("PO_SITE_ID") 
		 (PART "0" STARTING(0) ENDING(0) IN "DATA_SPACE" INDEX IN "S_P_O_SPACE", 
		 PART "1" STARTING(1) ENDING(1) IN "DATA_SPACE" INDEX IN "S_P_O_SPACE", 
		 PART "2" STARTING(2) ENDING(2) IN "DATA_SPACE" INDEX IN "S_P_O_SPACE", 
		 PART "3" STARTING(3) ENDING(3) IN "DATA_SPACE" INDEX IN "S_P_O_SPACE", 
		 PART "4" STARTING(4) ENDING(4) IN "DATA_SPACE" INDEX IN "S_P_O_SPACE", 
		 PART "5" STARTING(5) ENDING(5) IN "DATA_SPACE" INDEX IN "S_P_O_SPACE", 
		 PART "6" STARTING(6) ENDING(6) IN "DATA_SPACE" INDEX IN "S_P_O_SPACE", 
		 PART "7" STARTING(7) ENDING(7) IN "DATA_SPACE" INDEX IN "S_P_O_SPACE", 
		 PART "8" STARTING(8) ENDING(8) IN "DATA_SPACE" INDEX IN "S_P_O_SPACE", 
		 PART "9" STARTING(9) ENDING(10) IN "DATA_SPACE" INDEX IN "S_P_O_SPACE"); 






-- DDL Statements for indexes on Table "DB2INST1"."S_PURCH_ORDER"

CREATE INDEX "DB2INST1"."S_PODATE_IDX" ON "DB2INST1"."S_PURCH_ORDER" 
		("PO_SITE_ID" ASC,
		 "PO_START_DATE" ASC)
		PARTITIONED
		
		COMPRESS NO ALLOW REVERSE SCANS;

-- DDL Statements for indexes on Table "DB2INST1"."S_PURCH_ORDER"

CREATE UNIQUE INDEX "DB2INST1"."S_PO_IDX" ON "DB2INST1"."S_PURCH_ORDER" 
		("PO_SITE_ID" ASC,
		 "PO_NUMBER" ASC)
		PARTITIONED
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "SPECMRNODE01"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "SPECMRNODE01"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "USERSPACE1" INDEX IN "INDEX_SPACE" ; 





------------------------------------------------
-- DDL Statements for table "SPECMRNODE01"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "SPECMRNODE01"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16) , 
		  "INC_UUID" VARCHAR(16) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER )   
		 IN "USERSPACE1" INDEX IN "INDEX_SPACE" ; 





------------------------------------------------
-- DDL Statements for table "SPECMRNODE01"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "SPECMRNODE01"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048) NOT NULL )   
		 IN "USERSPACE1" INDEX IN "INDEX_SPACE" ; 


-- DDL Statements for primary key on Table "SPECMRNODE01"."SIBCLASSMAP"

ALTER TABLE "SPECMRNODE01"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for table "SPECMRNODE01"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "SPECMRNODE01"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10) , 
		  "TABLE_NAME" VARCHAR(10) NOT NULL , 
		  "TABLE_TYPE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" INDEX IN "INDEX_SPACE" ; 


-- DDL Statements for primary key on Table "SPECMRNODE01"."SIBLISTING"

ALTER TABLE "SPECMRNODE01"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "SPECMRNODE01"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "SPECMRNODE01"."SIBKEYS"  (
		  "ID" VARCHAR(50) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "USERSPACE1" INDEX IN "INDEX_SPACE" ; 


-- DDL Statements for primary key on Table "SPECMRNODE01"."SIBKEYS"

ALTER TABLE "SPECMRNODE01"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "SPECMRNODE01"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "SPECMRNODE01"."SIBXACTS"  (
		  "XID" VARCHAR(254) NOT NULL , 
		  "STATE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" INDEX IN "INDEX_SPACE" ; 


-- DDL Statements for primary key on Table "SPECMRNODE01"."SIBXACTS"

ALTER TABLE "SPECMRNODE01"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for table "SPECMRNODE01"."SIB000"
------------------------------------------------
 

CREATE TABLE "SPECMRNODE01"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE" ; 

ALTER TABLE "SPECMRNODE01"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for primary key on Table "SPECMRNODE01"."SIB000"

ALTER TABLE "SPECMRNODE01"."SIB000" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "SPECMRNODE01"."SIB001"
------------------------------------------------
 

CREATE TABLE "SPECMRNODE01"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE" ; 

ALTER TABLE "SPECMRNODE01"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for primary key on Table "SPECMRNODE01"."SIB001"

ALTER TABLE "SPECMRNODE01"."SIB001" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "SPECMRNODE01"."SIB002"
------------------------------------------------
 

CREATE TABLE "SPECMRNODE01"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE" ; 

ALTER TABLE "SPECMRNODE01"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for primary key on Table "SPECMRNODE01"."SIB002"

ALTER TABLE "SPECMRNODE01"."SIB002" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "SPECMRNODE02"."SIBOWNERO"
------------------------------------------------
 

CREATE TABLE "SPECMRNODE02"."SIBOWNERO"  (
		  "EMPTY_COLUMN" INTEGER )   
		 IN "USERSPACE1" INDEX IN "INDEX_SPACE" ; 





------------------------------------------------
-- DDL Statements for table "SPECMRNODE02"."SIBOWNER"
------------------------------------------------
 

CREATE TABLE "SPECMRNODE02"."SIBOWNER"  (
		  "ME_UUID" VARCHAR(16) , 
		  "INC_UUID" VARCHAR(16) , 
		  "VERSION" INTEGER , 
		  "MIGRATION_VERSION" INTEGER )   
		 IN "USERSPACE1" INDEX IN "INDEX_SPACE" ; 





------------------------------------------------
-- DDL Statements for table "SPECMRNODE02"."SIBCLASSMAP"
------------------------------------------------
 

CREATE TABLE "SPECMRNODE02"."SIBCLASSMAP"  (
		  "CLASSID" INTEGER NOT NULL , 
		  "URI" VARCHAR(2048) NOT NULL )   
		 IN "USERSPACE1" INDEX IN "INDEX_SPACE" ; 


-- DDL Statements for primary key on Table "SPECMRNODE02"."SIBCLASSMAP"

ALTER TABLE "SPECMRNODE02"."SIBCLASSMAP" 
	ADD PRIMARY KEY
		("CLASSID");


------------------------------------------------
-- DDL Statements for table "SPECMRNODE02"."SIBLISTING"
------------------------------------------------
 

CREATE TABLE "SPECMRNODE02"."SIBLISTING"  (
		  "ID" INTEGER NOT NULL , 
		  "SCHEMA_NAME" VARCHAR(10) , 
		  "TABLE_NAME" VARCHAR(10) NOT NULL , 
		  "TABLE_TYPE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" INDEX IN "INDEX_SPACE" ; 


-- DDL Statements for primary key on Table "SPECMRNODE02"."SIBLISTING"

ALTER TABLE "SPECMRNODE02"."SIBLISTING" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "SPECMRNODE02"."SIBKEYS"
------------------------------------------------
 

CREATE TABLE "SPECMRNODE02"."SIBKEYS"  (
		  "ID" VARCHAR(50) NOT NULL , 
		  "LAST_KEY" BIGINT NOT NULL )   
		 IN "USERSPACE1" INDEX IN "INDEX_SPACE" ; 


-- DDL Statements for primary key on Table "SPECMRNODE02"."SIBKEYS"

ALTER TABLE "SPECMRNODE02"."SIBKEYS" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "SPECMRNODE02"."SIBXACTS"
------------------------------------------------
 

CREATE TABLE "SPECMRNODE02"."SIBXACTS"  (
		  "XID" VARCHAR(254) NOT NULL , 
		  "STATE" CHAR(1) NOT NULL )   
		 IN "USERSPACE1" INDEX IN "INDEX_SPACE" ; 


-- DDL Statements for primary key on Table "SPECMRNODE02"."SIBXACTS"

ALTER TABLE "SPECMRNODE02"."SIBXACTS" 
	ADD PRIMARY KEY
		("XID");


------------------------------------------------
-- DDL Statements for table "SPECMRNODE02"."SIB000"
------------------------------------------------
 

CREATE TABLE "SPECMRNODE02"."SIB000"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE" ; 

ALTER TABLE "SPECMRNODE02"."SIB000" VOLATILE CARDINALITY;


-- DDL Statements for primary key on Table "SPECMRNODE02"."SIB000"

ALTER TABLE "SPECMRNODE02"."SIB000" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "SPECMRNODE02"."SIB001"
------------------------------------------------
 

CREATE TABLE "SPECMRNODE02"."SIB001"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE" ; 

ALTER TABLE "SPECMRNODE02"."SIB001" VOLATILE CARDINALITY;


-- DDL Statements for primary key on Table "SPECMRNODE02"."SIB001"

ALTER TABLE "SPECMRNODE02"."SIB001" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "SPECMRNODE02"."SIB002"
------------------------------------------------
 

CREATE TABLE "SPECMRNODE02"."SIB002"  (
		  "ID" BIGINT NOT NULL , 
		  "STREAM_ID" BIGINT NOT NULL , 
		  "TYPE" CHAR(2) , 
		  "EXPIRY_TIME" BIGINT , 
		  "STRATEGY" INTEGER , 
		  "REFERENCE" BIGINT , 
		  "CLASS_ID" INTEGER NOT NULL , 
		  "PRIORITY" INTEGER , 
		  "SEQUENCE" BIGINT , 
		  "PERMANENT_ID" INTEGER , 
		  "TEMPORARY_ID" INTEGER , 
		  "LOCK_ID" BIGINT , 
		  "DATA_SIZE" INTEGER NOT NULL , 
		  "DATA" VARCHAR(28869) FOR BIT DATA , 
		  "LONG_DATA" BLOB(1073741824) LOGGED NOT COMPACT , 
		  "XID" VARCHAR(254) , 
		  "DELETED" SMALLINT )   
		 IN "JMS_SPACE" INDEX IN "JMS_IDX_SPACE" ; 

ALTER TABLE "SPECMRNODE02"."SIB002" VOLATILE CARDINALITY;


-- DDL Statements for primary key on Table "SPECMRNODE02"."SIB002"

ALTER TABLE "SPECMRNODE02"."SIB002" 
	ADD PRIMARY KEY
		("ID");


------------------------------------------------
-- DDL Statements for table "DB2INST1"."S_PURCH_ORDERLINE"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."S_PURCH_ORDERLINE"  (
		  "POL_NUMBER" INTEGER NOT NULL , 
		  "POL_PO_ID" INTEGER NOT NULL , 
		  "POL_LOCATION" INTEGER NOT NULL , 
		  "POL_P_ID" CHAR(20) , 
		  "POL_QTY" INTEGER , 
		  "POL_BALANCE" DECIMAL(12,2) , 
		  "POL_LEADTIME" INTEGER WITH DEFAULT 0 , 
		  "POL_DELDATE" DATE , 
		  "POL_MESSAGE" VARCHAR(100) , 
		  "POL_VERSION" INTEGER WITH DEFAULT 0 )   
		 INDEX IN "S_P_OL_SPACE" PARTITION BY RANGE("POL_PO_ID") 
		 (PART "PART0" STARTING(0) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART1" STARTING(200000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART2" STARTING(400000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART3" STARTING(600000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART4" STARTING(800000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART5" STARTING(1000000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART6" STARTING(1200000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART7" STARTING(1400000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART8" STARTING(1600000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART9" STARTING(1800000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART10" STARTING(2000000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART11" STARTING(2200000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART12" STARTING(2400000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART13" STARTING(2600000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART14" STARTING(2800000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART15" STARTING(3000000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART16" STARTING(3200000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART17" STARTING(3400000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART18" STARTING(3600000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART19" STARTING(3800000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART20" STARTING(4000000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART21" STARTING(4200000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART22" STARTING(4400000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART23" STARTING(4600000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART24" STARTING(4800000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART25" STARTING(5000000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART26" STARTING(5200000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART27" STARTING(5400000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART28" STARTING(5600000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART29" STARTING(5800000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART30" STARTING(6000000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART31" STARTING(6200000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART32" STARTING(6400000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART33" STARTING(6600000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART34" STARTING(6800000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART35" STARTING(7000000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART36" STARTING(7200000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART37" STARTING(7400000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART38" STARTING(7600000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE", 
		 PART "PART39" STARTING(7800000) ENDING(8000000) IN "USERSPACE1" INDEX IN "S_P_OL_SPACE"); 






-- DDL Statements for indexes on Table "DB2INST1"."S_PURCH_ORDERLINE"

CREATE UNIQUE INDEX "DB2INST1"."S_POL_IDX" ON "DB2INST1"."S_PURCH_ORDERLINE" 
		("POL_LOCATION" ASC,
		 "POL_PO_ID" ASC,
		 "POL_NUMBER" ASC)
		PARTITIONED
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."M_WORKORDER"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."M_WORKORDER"  (
		  "WO_NUMBER" INTEGER NOT NULL , 
		  "WO_LOCATION" INTEGER NOT NULL , 
		  "WO_O_ID" INTEGER , 
		  "WO_OL_ID" INTEGER , 
		  "WO_STATUS" INTEGER , 
		  "WO_ASSEMBLY_ID" CHAR(20) , 
		  "WO_ORIG_QTY" INTEGER , 
		  "WO_COMP_QTY" INTEGER , 
		  "WO_DUE_DATE" TIMESTAMP , 
		  "WO_START_DATE" TIMESTAMP , 
		  "WO_VERSION" INTEGER WITH DEFAULT 0 )   
		 INDEX IN "M_WO2_SPACE" PARTITION BY RANGE("WO_NUMBER") 
		 (PART "PART0" STARTING(0) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART1" STARTING(280000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART2" STARTING(560000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART3" STARTING(840000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART4" STARTING(1120000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART5" STARTING(1400000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART6" STARTING(1680000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART7" STARTING(1960000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART8" STARTING(2240000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART9" STARTING(2520000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART10" STARTING(2800000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART11" STARTING(3080000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART12" STARTING(3360000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART13" STARTING(3640000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART14" STARTING(3920000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART15" STARTING(4200000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART16" STARTING(4480000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART17" STARTING(4760000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART18" STARTING(5040000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART19" STARTING(5320000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART20" STARTING(5600000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART21" STARTING(5880000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART22" STARTING(6160000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART23" STARTING(6440000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART24" STARTING(6720000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART25" STARTING(7000000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART26" STARTING(7280000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART27" STARTING(7560000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART28" STARTING(7840000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART29" STARTING(8120000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART30" STARTING(8400000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART31" STARTING(8680000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART32" STARTING(8960000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART33" STARTING(9240000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART34" STARTING(9520000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART35" STARTING(9800000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART36" STARTING(10080000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART37" STARTING(10360000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART38" STARTING(10640000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART39" STARTING(10920000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART40" STARTING(11200000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART41" STARTING(11480000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART42" STARTING(11760000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART43" STARTING(12040000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART44" STARTING(12320000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART45" STARTING(12600000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART46" STARTING(12880000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART47" STARTING(13160000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART48" STARTING(13440000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART49" STARTING(13720000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART50" STARTING(14000000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART51" STARTING(14280000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART52" STARTING(14560000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART53" STARTING(14840000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART54" STARTING(15120000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART55" STARTING(15400000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART56" STARTING(15680000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART57" STARTING(15960000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART58" STARTING(16240000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART59" STARTING(16520000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART60" STARTING(16800000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART61" STARTING(17080000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART62" STARTING(17360000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART63" STARTING(17640000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART64" STARTING(17920000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART65" STARTING(18200000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART66" STARTING(18480000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART67" STARTING(18760000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART68" STARTING(19040000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART69" STARTING(19320000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART70" STARTING(19600000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART71" STARTING(19880000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART72" STARTING(20160000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART73" STARTING(20440000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART74" STARTING(20720000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART75" STARTING(21000000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART76" STARTING(21280000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART77" STARTING(21560000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART78" STARTING(21840000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART79" STARTING(22120000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART80" STARTING(22400000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART81" STARTING(22680000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART82" STARTING(22960000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART83" STARTING(23240000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART84" STARTING(23520000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART85" STARTING(23800000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART86" STARTING(24080000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART87" STARTING(24360000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART88" STARTING(24640000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART89" STARTING(24920000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART90" STARTING(25200000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART91" STARTING(25480000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART92" STARTING(25760000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART93" STARTING(26040000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART94" STARTING(26320000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART95" STARTING(26600000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART96" STARTING(26880000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART97" STARTING(27160000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART98" STARTING(27440000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART99" STARTING(27720000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART100" STARTING(28000000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART101" STARTING(28280000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART102" STARTING(28560000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART103" STARTING(28840000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART104" STARTING(29120000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART105" STARTING(29400000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART106" STARTING(29680000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART107" STARTING(29960000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART108" STARTING(30240000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART109" STARTING(30520000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART110" STARTING(30800000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART111" STARTING(31080000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART112" STARTING(31360000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART113" STARTING(31640000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART114" STARTING(31920000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART115" STARTING(32200000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART116" STARTING(32480000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART117" STARTING(32760000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART118" STARTING(33040000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART119" STARTING(33320000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART120" STARTING(33600000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART121" STARTING(33880000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART122" STARTING(34160000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART123" STARTING(34440000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART124" STARTING(34720000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART125" STARTING(35000000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART126" STARTING(35280000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART127" STARTING(35560000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART128" STARTING(35840000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART129" STARTING(36120000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART130" STARTING(36400000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART131" STARTING(36680000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART132" STARTING(36960000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART133" STARTING(37240000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART134" STARTING(37520000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART135" STARTING(37800000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART136" STARTING(38080000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART137" STARTING(38360000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART138" STARTING(38640000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART139" STARTING(38920000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART140" STARTING(39200000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART141" STARTING(39480000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART142" STARTING(39760000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART143" STARTING(40040000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART144" STARTING(40320000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART145" STARTING(40600000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART146" STARTING(40880000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART147" STARTING(41160000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART148" STARTING(41440000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART149" STARTING(41720000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART150" STARTING(42000000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART151" STARTING(42280000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART152" STARTING(42560000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART153" STARTING(42840000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART154" STARTING(43120000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART155" STARTING(43400000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART156" STARTING(43680000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART157" STARTING(43960000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART158" STARTING(44240000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART159" STARTING(44520000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART160" STARTING(44800000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART161" STARTING(45080000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART162" STARTING(45360000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART163" STARTING(45640000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART164" STARTING(45920000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART165" STARTING(46200000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART166" STARTING(46480000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART167" STARTING(46760000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART168" STARTING(47040000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART169" STARTING(47320000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART170" STARTING(47600000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART171" STARTING(47880000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART172" STARTING(48160000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART173" STARTING(48440000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART174" STARTING(48720000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART175" STARTING(49000000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART176" STARTING(49280000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART177" STARTING(49560000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART178" STARTING(49840000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART179" STARTING(50120000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART180" STARTING(50400000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART181" STARTING(50680000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART182" STARTING(50960000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART183" STARTING(51240000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART184" STARTING(51520000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART185" STARTING(51800000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART186" STARTING(52080000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART187" STARTING(52360000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART188" STARTING(52640000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART189" STARTING(52920000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART190" STARTING(53200000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART191" STARTING(53480000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART192" STARTING(53760000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART193" STARTING(54040000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART194" STARTING(54320000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART195" STARTING(54600000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART196" STARTING(54880000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART197" STARTING(55160000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART198" STARTING(55440000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART199" STARTING(55720000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART200" STARTING(56000000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART201" STARTING(56280000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART202" STARTING(56560000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART203" STARTING(56840000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART204" STARTING(57120000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART205" STARTING(57400000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART206" STARTING(57680000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART207" STARTING(57960000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART208" STARTING(58240000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART209" STARTING(58520000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART210" STARTING(58800000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART211" STARTING(59080000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART212" STARTING(59360000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART213" STARTING(59640000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART214" STARTING(59920000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART215" STARTING(60200000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART216" STARTING(60480000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART217" STARTING(60760000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART218" STARTING(61040000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART219" STARTING(61320000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART220" STARTING(61600000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART221" STARTING(61880000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART222" STARTING(62160000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART223" STARTING(62440000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART224" STARTING(62720000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART225" STARTING(63000000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART226" STARTING(63280000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART227" STARTING(63560000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART228" STARTING(63840000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART229" STARTING(64120000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART230" STARTING(64400000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART231" STARTING(64680000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART232" STARTING(64960000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART233" STARTING(65240000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART234" STARTING(65520000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART235" STARTING(65800000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART236" STARTING(66080000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART237" STARTING(66360000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART238" STARTING(66640000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART239" STARTING(66920000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART240" STARTING(67200000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART241" STARTING(67480000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART242" STARTING(67760000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART243" STARTING(68040000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART244" STARTING(68320000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART245" STARTING(68600000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART246" STARTING(68880000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART247" STARTING(69160000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART248" STARTING(69440000) IN "USERSPACE1" INDEX IN "M_WO_SPACE", 
		 PART "PART249" STARTING(69720000) ENDING(70000000) IN "USERSPACE1" INDEX IN "M_WO_SPACE"); 






-- DDL Statements for indexes on Table "DB2INST1"."M_WORKORDER"

CREATE UNIQUE INDEX "DB2INST1"."M_WO_IDX" ON "DB2INST1"."M_WORKORDER" 
		("WO_LOCATION" ASC,
		 "WO_NUMBER" ASC)
		PARTITIONED
		
		COMPRESS NO ALLOW REVERSE SCANS;

-- DDL Statements for indexes on Table "DB2INST1"."M_WORKORDER"

CREATE INDEX "DB2INST1"."M_WO_OOL_IDX" ON "DB2INST1"."M_WORKORDER" 
		("WO_LOCATION" ASC,
		 "WO_O_ID" ASC,
		 "WO_OL_ID" ASC)
		PARTITIONED
		
		COMPRESS NO ALLOW REVERSE SCANS;







COMMIT WORK;

CONNECT RESET;

TERMINATE;

