#! /bin/bash

MYPATH=$(dirname $(readlink -f $0))

set -x
DB=specdb
DB_DIR=/specjdb
IR=''
app_instances=1

for arg; do export "$arg"; done

if [ -z "$app_host" ]; then
    echo "You must specify the application server host name with the app_host= parameter."
    echo "Optionally specify the number of application server instances with the app_instances= parameter (default 1)."
    exit 1
fi

echo -e "\nStopping DB2\n"
db2 -v disconnect all
db2 -v force applications all
db2stop force
db2 -v terminate

FREE_MEM_KB=$(grep MemFree /proc/meminfo | awk '{print $2}')

db2start
echo -e "\ndrop DB\n"
db2 -v drop db $DB


db2set DB2_APM_PERFORMANCE=
db2set DB2_LARGE_PAGE_MEM=DB
db2set DB2_PMODEL_SETTINGS=MAX_BACKGROUND_SYSAPPS:500
db2 -v update database manager configuration using SPM_MAX_RESYNC 40

db2stop
db2start

echo -e "\nCreating database $DB on $DB_DIR\n"
rm -rf $DB_DIR/NODE[0-9][0-9][0-9][0-9]
db2 -v create db $DB on $DB_DIR

echo -e "\nSetting database schema.\n"
db2 -v -tvf $KIT_HOME/autobench/schema.ddl

echo -e "\nSetup JMS\n"
$KIT_HOME/autobench/setupJMS.sh app_host=$app_host app_instances=$app_instances

echo -e "\nUpdate database configuration\n"
db2 -v connect to $DB

db2 -v update db cfg using newlogpath $DB_DIR/$USER
db2 -v update db cfg using logfilsiz 65535
db2 -v update db cfg for $DB using logprimary 256 logsecond 0
db2 -v update db cfg for $DB using LOCKLIST 100000 MAXLOCKS 100
db2stop force
db2start

if [ -n "$IR" ]; then
    flatfile_dir=$DB_DIR/${IR}IR/flatfiles
    sed -i -e 's|^\(loader.standalone.flatFileDirectory=\).*|\1'$flatfile_dir'|' $KIT_HOME/build.properties
    sed -i -e 's|^\(benchmark.txrate=\).*|\1'$IR'|' $KIT_HOME/build.properties
else
    flatfile_dir=$(grep '^loader.standalone.flatFileDirectory=' $KIT_HOME/build.properties | cut -d= -f2)
fi
if [ -d "$flatfile_dir" ]; then
    parallelism=$(grep '^loader.standalone.parallelism=' $KIT_HOME/build.properties | cut -d= -f2)
    if ! ls $flatfile_dir/O_* &>/dev/null; then
	echo -e "\nCreating flat files using ant script\n"
	ant -buildfile $KIT_HOME/build.xml load.flatfiles
    fi
    echo -e "\nLoading database from flat files\n"
    $KIT_HOME/autobench/db2load.sh.linux.spec2009 $flatfile_dir $parallelism
else
    echo -e "\nLoading database using ant script\n"
    ant -buildfile $KIT_HOME/build.xml load.database
fi

db2 -v connect to $DB
echo -e "\nAdding pctfree on order tables\n"
db2 -v alter table O_ORDERLINE pctfree 99
db2 -v alter table O_CUSTINVENTORY pctfree 99
db2 -v alter table O_ORDERS pctfree 99

echo -e "\nTurning off self-tuning memory managment\n"
db2 -v update db cfg using self_tuning_mem off

echo -e "\nApplying DB2 tunings\n"
$MYPATH/db2tune.sh DB=$DB DB_DIR=$DB_DIR

echo -e "\nStart reorgchk\n"
db2 -v reorgchk update statistics

echo -e "\nBacking up databse $DB to $DB_DIR/${IR}IR/db-backup/\n"
db2 -v backup db $DB to $DB_DIR/${IR}IR/db-backup

echo -e "\nStopping DB2\n"
db2 -v disconnect all
db2 -v force applications all
db2stop force
db2 -v terminate

echo -e "\nDone\n"
