#!/bin/sh
#
SUDO=sudo
ZNAME=jent

N_ZINETD=`ps -ef | grep inetd | grep -v grep | wc -l`
if [ $N_ZINETD -lt 4 ]; then
	echo "Not all inetd processes running".
	exit 2
fi

#
# Now bind the zones
PSET=1
for Z in 71 72 73 74
do
        ZONENAME=$ZNAME$Z
        echo "Binding processes in $ZONENAME to processor set $PSET"
        PIDS=`pgrep -z $ZONENAME`
        for P in $PIDS
        do
                $SUDO /usr/sbin/psrset -b $PSET $P
        done
        PSET=`expr $PSET + 1`
done

mpstat -a

