#!/bin/sh
#
# Script to create oracle database

if [ "$ORACLE_HOME" = "" ]
then
        echo "$ORACLE_HOME"
        echo "You must set the ORACLE_HOME environment variable"
        exit 1
fi

if [ "$ORACLE_SID" = "" ]
then
        echo "$ORACLE_SID"
        echo "You must set the ORACLE_SID environment variable"
        exit 1
fi

####################
# Set the database and database directory vars
#####################
DB=${ORACLE_SID}
DB_DIR="+DATA"
LOG_DIR1="+LOG1"
LOG_DIR2="+LOG2"

####################################
# Check to see that the target database directory
# exists and has write permission.
####################################
#if [ ! -d "$DB_DIR" ]
#then
#        echo "$DB_DIR does not exist. Please create it first."
#        exit 1
#fi


########################################################
# Go and run the create_init.sh script
# to build the correct pfiles and .ora files for Oracle 
########################################################
if [ ! -f "$ORACLE_HOME/dbs/init${DB}.ora" ]
then
        echo "$ORACLE_HOME/dbs/init${DB}.ora does not exist. Please create it first."
        exit 1
fi

SYS=${DB_DIR}/sys_${DB}
SYS_AUX=${DB_DIR}/sysaux_${DB}

LOG1=${LOG_DIR1}/log1_${DB}
LOG2=${LOG_DIR2}/log2_${DB}
LOGSZ="800000M"

TEMP=${DB_DIR}/temp_${DB}
TEMPSZ="70000M"
UNDO=${DB_DIR}/undo_${DB}
UNDOSZ="200000M"


# Create database
sqlplus <<EOT
CONNECT / as sysdba
shutdown;
startup nomount

CREATE DATABASE ${DB}
CONTROLFILE REUSE
LOGFILE GROUP 1 '${LOG1}' SIZE ${LOGSZ} REUSE,
        GROUP 2 '${LOG2}' SIZE ${LOGSZ} REUSE
MAXDATAFILES 200
DATAFILE '${SYS}' size 5000M REUSE
SYSAUX DATAFILE '${SYS_AUX}' size 8000M REUSE
BIGFILE DEFAULT TEMPORARY TABLESPACE temp_ts
    TEMPFILE '${TEMP}' SIZE ${TEMPSZ} REUSE
BIGFILE UNDO TABLESPACE undo_ts DATAFILE '${UNDO}' SIZE ${UNDOSZ} REUSE
    BLOCKSIZE 8k;

exit
EOT


echo "Running catalog scripts ..."
sqlplus <<EOT
CONNECT / as sysdba
@?/rdbms/admin/catalog;
@?/rdbms/admin/catexp.sql
@?/rdbms/admin/catldr.sql
@?/rdbms/admin/catproc.sql
@?/rdbms/admin/catparr.sql
@?/rdbms/admin/utlmontr;
EXIT
EOT

echo "Catalog done."

sqlplus <<EOT
CONNECT / as sysdba
drop user spec;
CREATE USER spec IDENTIFIED BY spec;
GRANT CONNECT, RESOURCE TO spec;
GRANT ALL PRIVILEGES TO spec IDENTIFIED BY spec;

ALTER USER spec
        TEMPORARY TABLESPACE temp_ts;
EXIT
EOT

