#!/bin/ksh
#
SUDO=/usr/bin/sudo
PCITOOL=/usr/sbin/pcitool


CPU_START=0
CPU_OFF=128
PSET_OFF=64

set -A nexus_arr 301 301 302 302 302 302 300 300 300 300 305 305 303 303 302 302
set -A inst_arr    0   1   2   3   4   5   6   7   8   9  10  11  12  13  14  15 
set -A inst_start 128  0 128 128   0   0 384   0 128 128   0   0   0   0   0   0
set -A tgt_cnt     8  16   8   8   8   8   8   8   8   8  16  16   8   8   8   8

set -A inst_tgt    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
for X in 4 5 7 2 3 0
do
        I=${inst_arr[$X]}
        echo Configuring intrs for ixgbe#${I}
        NEXUS=/`ls -l /dev/ixgbe${I} | awk '{print $11}' | cut -d / -f3`
        echo $NEXUS
        ino_cnt=16
        set -A ino_arr `$SUDO $PCITOOL $NEXUS -i | grep ixgbe#${I} | sort +7 | tail -16 | sort +0.10 | awk '{print $3}'`

        T=15
        TC=${tgt_cnt[$X]}
        TGT=${inst_start[$X]}
        while [ $T -ge 0 ]; do
                inst_tgt[$T]=`printf "%x" $TGT`
                TC=`expr $TC - 1`
                TGT=`expr $TGT + 1`
                if [ $TC -eq 8 ]; then
                        TGT=${inst_start[$X]}
			TGT=`expr $TGT + 64`
                fi
                if [ $TC -eq 0 ]; then
                        TC=${tgt_cnt[$X]}
                        TGT=${inst_start[$X]}
                fi
                T=`expr $T - 1`
        done

        echo "Targeted cpus: "
        T=0
        while [ $T -lt 16 ]; do
                echo $T: "0x${inst_tgt[$T]} -> ${ino_arr[$T]}"
                T=`expr $T + 1`
        done

        i=0
        while [ $i -lt $ino_cnt ] ; do
                $SUDO $PCITOOL $NEXUS -m ${ino_arr[$i]} -w ${inst_tgt[$i]}
                i=`expr $i + 1`
        done

done

