CREATE TABLE P_ACTUARIAL_CLASS (ID INTEGER NOT NULL, COMPANY VARCHAR(255) NOT NULL, DEFAULTDRIVERRATE FLOAT, DEFAULTVEHICLERATE FLOAT, PRIMARY KEY (ID))
CREATE TABLE P_COVERAGE_CLASS (ID INTEGER NOT NULL, COVERAGE INTEGER, MAXDEDUCTIBLE INTEGER, MAXLIMIT INTEGER, MINDEDUCTIBLE INTEGER, MINLIMIT INTEGER, RATERELATIVITY FLOAT, COVERAGES_ID INTEGER, DEFAULTCOVERAGES_ID INTEGER, PRIMARY KEY (ID))
CREATE TABLE P_VEHICLE_CLASS (ID INTEGER NOT NULL, MANUFACTURER VARCHAR(255), MAXANNUALMILES INTEGER, MAXVALUE INTEGER, MAXYEAR INTEGER, MINANNUALMILES INTEGER, MINVALUE INTEGER, MINYEAR INTEGER, MODEL VARCHAR(255), RATERELATIVITY FLOAT, VEHICLES_ID INTEGER, PRIMARY KEY (ID))
CREATE TABLE P_DRIVER_CLASS (ID INTEGER NOT NULL, GENDER INTEGER, MAXACCIDENTS INTEGER, MAXAGE INTEGER, MAXCLAIMS INTEGER, MAXVIOLATIONS INTEGER, MINACCIDENTS INTEGER, MINAGE INTEGER, MINCLAIMS INTEGER, MINVIOLATIONS INTEGER, RATERELATIVITY FLOAT, DRIVERS_ID INTEGER, PRIMARY KEY (ID))
ALTER TABLE P_ACTUARIAL_CLASS ADD CONSTRAINT P_ACTUARIAL_CLASS0 UNIQUE (company)
ALTER TABLE P_COVERAGE_CLASS ADD CONSTRAINT PCVRGECLASSCVRGSID FOREIGN KEY (COVERAGES_ID) REFERENCES P_ACTUARIAL_CLASS (ID)
ALTER TABLE P_COVERAGE_CLASS ADD CONSTRAINT PCVRGCLSDFLTCVRGSD FOREIGN KEY (DEFAULTCOVERAGES_ID) REFERENCES P_ACTUARIAL_CLASS (ID)
ALTER TABLE P_VEHICLE_CLASS ADD CONSTRAINT PVHCLECLASSVHCLSID FOREIGN KEY (VEHICLES_ID) REFERENCES P_ACTUARIAL_CLASS (ID)
ALTER TABLE P_DRIVER_CLASS ADD CONSTRAINT PDRVERCLASSDRVRSID FOREIGN KEY (DRIVERS_ID) REFERENCES P_ACTUARIAL_CLASS (ID)
CREATE SEQUENCE P_VEHICLE_SEQUENCE INCREMENT BY 100 START WITH 100
CREATE SEQUENCE P_COVERAGE_SEQUENCE INCREMENT BY 100 START WITH 100
CREATE SEQUENCE P_ACTUARIAL_SEQUENCE INCREMENT BY 100 START WITH 100
CREATE SEQUENCE P_DRIVER_SEQUENCE INCREMENT BY 100 START WITH 100
