#!/usr/bin/env bash

#"INTEL CONFIDENTIAL"
#Copyright 2015  Intel Corporation All Rights Reserved. 
#
#The source code contained or described herein and all documents related to the source code ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets and proprietary and confidential information of Intel or its suppliers and licensors. The Material is protected by worldwide copyright and trade secret laws and treaty provisions. No part of the Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted, distributed, or disclosed in any way without Intel's prior express written permission.
#
#No license under any patent, copyright, trade secret or other intellectual property right is granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by implication, inducement, estoppel or otherwise. Any license under such intellectual property rights must be express and approved by Intel in writing.

runEngineCmd () {
  if addInitScriptsToParams
  then
    "$BINARY" "${BINARY_PARAMS[@]}" $INIT_PARAMS "$@"
  else
    return 1
  fi
}

addInitScriptsToParams () {
  INIT_PARAMS="-i $BIG_BENCH_QUERY_PARAMS_FILE -i $BIG_BENCH_ENGINE_SETTINGS_FILE"

  if [[ -n "$LOCAL_QUERY_ENGINE_SETTINGS_FILE" && -r "$LOCAL_QUERY_ENGINE_SETTINGS_FILE" ]]
  then
    INIT_PARAMS="$INIT_PARAMS -i $LOCAL_QUERY_ENGINE_SETTINGS_FILE"
  fi

  if [ -n "$USER_QUERY_PARAMS_FILE" ]
  then
    if [ -r "$USER_QUERY_PARAMS_FILE" ]
    then
      INIT_PARAMS="$INIT_PARAMS -i $USER_QUERY_PARAMS_FILE"
    else
      echo "User query parameter file $USER_QUERY_PARAMS_FILE can not be read."
      return 1
    fi
  fi

  if [ -n "$USER_ENGINE_SETTINGS_FILE" ]
  then
    if [ -r "$USER_ENGINE_SETTINGS_FILE" ]
    then
      INIT_PARAMS="$INIT_PARAMS -i $USER_ENGINE_SETTINGS_FILE"
    else
      echo "User hive settings file $USER_ENGINE_SETTINGS_FILE can not be read."
      return 1
    fi
  fi
  return 0
}

initQueryEnv () {
  if [ -z "$QUERY_NUMBER" ]
  then
    echo "The query number must be set."
    return 1
  fi

  if [ $QUERY_NUMBER -lt 1 ]
  then
    echo "Query number must be greater than 0"
    return 1
  fi

  if [ $QUERY_NUMBER -lt 10 ]
  then
    QUERY_NAME=q0$QUERY_NUMBER
  else
    QUERY_NAME=q$QUERY_NUMBER
  fi

  QUERY_DIR="$BIG_BENCH_QUERIES_DIR/$QUERY_NAME"
  if [ ! -d "$QUERY_DIR" ]
  then
    echo "Query directory $QUERY_DIR does not exist"
    return 1
  fi

  VALIDATION_RESULTS_DIR="$QUERY_DIR/results"
  if [ ! -d "$VALIDATION_RESULTS_DIR" ]
  then
    echo "Validation results directory $VALIDATION_RESULTS_DIR does not exist"
    return 1
  fi
  VALIDATION_RESULTS_FILENAME="$VALIDATION_RESULTS_DIR/$QUERY_NAME-result"

  LOCAL_QUERY_ENGINE_SETTINGS_FILE="$QUERY_DIR/hiveLocalSettings.sql"
  if ! addInitScriptsToParams
  then
    return 1
  fi

  TABLE_PREFIX="${QUERY_NAME}_${BIG_BENCH_ENGINE}_${BIG_BENCH_BENCHMARK_PHASE}_${BIG_BENCH_STREAM_NUMBER}"

  RESULT_TABLE="${TABLE_PREFIX}_result"
  RESULT_DIR="$BIG_BENCH_HDFS_ABSOLUTE_QUERY_RESULT_DIR/$RESULT_TABLE"
  TEMP_TABLE="${TABLE_PREFIX}_temp"
  TEMP_DIR="$BIG_BENCH_HDFS_ABSOLUTE_TEMP_DIR/$TEMP_TABLE"

  LOG_FILE_NAME="$BIG_BENCH_LOGS_DIR/${TABLE_PREFIX}.log"

  #echo "set BIG_BENCH_BENCHMARK_PHASE=\"$BIG_BENCH_BENCHMARK_PHASE\";" >> "$LOCAL_QUERY_ENGINE_SETTINGS_FILE"
  #echo "set BIG_BENCH_STREAM_NUMBER=\"$BIG_BENCH_STREAM_NUMBER\";" >> "$LOCAL_QUERY_ENGINE_SETTINGS_FILE"
  #echo "set QUERY_NAME=\"$QUERY_NAME\";" >> "$LOCAL_QUERY_ENGINE_SETTINGS_FILE"
  #echo "set QUERY_DIR=\"$QUERY_DIR\";" >> "$LOCAL_QUERY_ENGINE_SETTINGS_FILE"
  #echo "set RESULT_TABLE=\"$RESULT_TABLE\";" >> "$LOCAL_QUERY_ENGINE_SETTINGS_FILE"
  #echo "set RESULT_DIR=\"$RESULT_DIR\";" >> "$LOCAL_QUERY_ENGINE_SETTINGS_FILE"
  #echo "set TEMP_TABLE=\"$TEMP_TABLE\";" >> "$LOCAL_QUERY_ENGINE_SETTINGS_FILE"
  #echo "set TEMP_DIR=\"$TEMP_DIR\";" >> "$LOCAL_QUERY_ENGINE_SETTINGS_FILE"
  #echo "set TABLE_PREFIX=\"$TABLE_PREFIX\";" >> "$LOCAL_QUERY_ENGINE_SETTINGS_FILE"

  LOCAL_QUERY_ENGINE_SETTINGS_CONF_FILE="$QUERY_DIR/engineLocalSettings.conf"
  if [ -f "$LOCAL_QUERY_ENGINE_SETTINGS_CONF_FILE" ]
  then
    source $LOCAL_QUERY_ENGINE_SETTINGS_CONF_FILE
  fi

  BINARY_PARAMS+=(--hiveconf BENCHMARK_PHASE=$BIG_BENCH_BENCHMARK_PHASE --hiveconf STREAM_NUMBER=$BIG_BENCH_STREAM_NUMBER --hiveconf QUERY_NAME=$QUERY_NAME --hiveconf QUERY_DIR=$QUERY_DIR --hiveconf RESULT_TABLE=$RESULT_TABLE --hiveconf RESULT_DIR=$RESULT_DIR --hiveconf TEMP_TABLE=$TEMP_TABLE --hiveconf TEMP_DIR=$TEMP_DIR --hiveconf TABLE_PREFIX=$TABLE_PREFIX)

  # source run.sh as late as possible to allow run.sh to use all above defined variables
  SCRIPT_FILENAME="$QUERY_DIR/run.sh"
  if [ -r "$SCRIPT_FILENAME" ]
  then
    source "$SCRIPT_FILENAME"
  else
    echo "File $SCRIPT_FILENAME containing main method not found, aborting script."
    return 1
  fi

  # check if the main method was implemented properly in the run.sh
  QUERY_MAIN_METHOD="query_run_main_method"
  if ! declare -F "$QUERY_MAIN_METHOD" > /dev/null 2>&1
  then
    echo "$QUERY_MAIN_METHOD was not implemented, aborting script"
    return 1
  fi

  # check if the clean method was implemented properly in the run.sh
  QUERY_CLEAN_METHOD="query_run_clean_method"
  if ! declare -F "$QUERY_CLEAN_METHOD" > /dev/null 2>&1
  then
    echo "$QUERY_CLEAN_METHOD was not implemented, aborting script"
    return 1
  fi

  # check if the verify method was implemented properly in the run.sh
  QUERY_VALIDATE_METHOD="query_run_validate_method"
  if ! declare -F "$QUERY_VALIDATE_METHOD" > /dev/null 2>&1
  then
    echo "$QUERY_VALIDATE_METHOD was not implemented, aborting script"
    return 1
  fi
  return 0
}

export BIG_BENCH_ENGINE_BIN_DIR="$BIG_BENCH_ENGINE_DIR/bin"
export BIG_BENCH_QUERIES_DIR="$BIG_BENCH_ENGINE_DIR/queries"
export BIG_BENCH_CLEAN_DIR="$BIG_BENCH_ENGINE_DIR/clean"
export BIG_BENCH_POPULATION_DIR="$BIG_BENCH_ENGINE_DIR/population"
export BIG_BENCH_REFRESH_DIR="$BIG_BENCH_ENGINE_DIR/refresh"

export BIG_BENCH_CLEAN_METASTORE_FILE="$BIG_BENCH_CLEAN_DIR/dropTables.sql"
export BIG_BENCH_POPULATE_METASTORE_FILE="${USER_POPULATE_FILE:-"$BIG_BENCH_POPULATION_DIR/hiveCreateLoad_decimal.sql"}"
export BIG_BENCH_REFRESH_METASTORE_FILE="${USER_REFRESH_FILE:-"$BIG_BENCH_REFRESH_DIR/hiveRefreshCreateLoad_decimal.sql"}"
export BIG_BENCH_QUERY_PARAMS_FILE="$BIG_BENCH_ENGINE_CONF_DIR/queryParameters.sql"
export BIG_BENCH_ENGINE_SETTINGS_FILE="$BIG_BENCH_ENGINE_CONF_DIR/hiveSettings.sql"

if [ ! -f "$BIG_BENCH_CLEAN_METASTORE_FILE" ]
then
  echo "Clean metastore file $BIG_BENCH_CLEAN_METASTORE_FILE not found"
  exit 1
fi

if [ ! -f "$BIG_BENCH_POPULATE_METASTORE_FILE" ]
then
  echo "Clean metastore file $BIG_BENCH_POPULATE_METASTORE_FILE not found"
  exit 1
fi

if [ ! -f "$BIG_BENCH_REFRESH_METASTORE_FILE" ]
then
  echo "Clean metastore file $BIG_BENCH_REFRESH_METASTORE_FILE not found"
  exit 1
fi

if [ ! -f "$BIG_BENCH_QUERY_PARAMS_FILE" ]
then
  echo "Clean metastore file $BIG_BENCH_QUERY_PARAMS_FILE not found"
  exit 1
fi

if [ ! -f "$BIG_BENCH_ENGINE_SETTINGS_FILE" ]
then
  echo "Clean metastore file $BIG_BENCH_ENGINE_SETTINGS_FILE not found"
  exit 1
fi

## ==========================
## HIVE (recommended minimum version v0.12)
## ==========================
#choices: TEXTFILE, RCFILE, ORC, SEQUENCEFILE, PARQUET, AVRO or: "INPUTFORMAT input_format_classname OUTPUTFORMAT output_format_classname"
export BIG_BENCH_hive_default_fileformat_source_table="ORC"
export BIG_BENCH_hive_default_fileformat_result_table="TEXTFILE"

BINARY="/opt/createApacheCluster/hive/bin/hive"
BINARY_PARAMS=()

## Kmeans fails when running on HDFS and execution mode "mapreduce" https://issues.apache.org/jira/browse/MAHOUT-1658
export BIG_BENCH_ENGINE_HIVE_MAHOUT_EXECUTION="sequential"
