#!/bin/bash

###########################################################################
#                                                                         #
#  Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC). #
#  All rights reserved.                                                   #
#                                                                         #
###########################################################################

# AddVMDisk.sh - add /datastore disk 
#
# Adapted from /usr/lib/vmware-vcli/apps/vm/vmclone.pl for SPECvirt Datacenter 2021 
#
if [ "$#" -ne 1 ]; then
   echo "Usage:  ./AddVMDisk.sh <size in GB>"
   exit 1
fi

# Set up environment variables
. /export/home/cp/bin/getVars.sh

# Generate random string for data disk
diskName=`head /dev/urandom | tr -dc A-Za-z0-9 | head -c 8 ; echo ''`

disksizeGB=$1
# Convert to MB
disksizeMB=$(( $disksizeGB * 1024 ))

     ./vdiskcreate.pl --server $mgmtServerIP --username $virtUser --password $virtPassword \
        --vmname "svdc-director" --filename svdc-director-$diskName --disksize $disksizeMB

