#!/bin/bash

###########################################################################
#                                                                         #
#  Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC). #
#  All rights reserved.                                                   #
#                                                                         #
###########################################################################

# DeleteVM.sh - powers off a VM and deletes it 
#
# Adapted from /usr/lib/vmware-vcli/apps/vm/vmregister.pl
#    for SPECvirt Datacenter (svdc)
#
# $1 = targetVM 

# Set up environment variables
. /export/home/cp/bin/getVars.sh > /dev/null

targetVM=$1

# Hard poweroff OK since VM is being deleted
./vmcontrol.pl --server $mgmtServerIP --username $virtUser --password $virtPassword \
      --operation poweroff --vmname $targetVM > /dev/null 2>&1

sleep 3

echo "Deleting $targetVM..."
  ./vmdelete.pl --server $mgmtServerIP --username $virtUser --password $virtPassword \
      --operation delete --vmname $targetVM > /dev/null 2>&1
