#!/bin/bash

###########################################################################
#                                                                         #
#  Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC). #
#  All rights reserved.                                                   #
#                                                                         #
###########################################################################

#Script to deploy and Power On the VM
# $1 = targetVM
# $2 = macAddress

if [ "$#" -ne 2 ]; then
   echo "Usage:  ./DeployVM-AIO.sh <targetVM> <mac address>"
   exit 1
fi

vm_present="fail"
retry=0

# Set up environment variables
. /export/home/cp/bin/getVars.sh
SCRIPT_LOG_FILE=/export/home/cp/log/${virtVendor}_scripts.log

cd /export/home/cp/config/workloads/specvirt/HV_Operations/vSphere

targetVM=$1
echo $(date -u) "DeployVM-AIO script for ${targetVM} started." |& tee -a $SCRIPT_LOG_FILE

macAddress=$2

echo $(date -u) "Deploying " $targetVM |& tee -a $SCRIPT_LOG_FILE

while [[ $vm_present != "pass" ]]
do
  if [[ $targetVM == *"mail"* ]]; then
    tilenum=`expr substr ${1} 7 3`
    numPools=`expr $mailLastPool + 1`
    tileIndex=`expr $tilenum + $numPools - 1`
    poolIndex=`expr $tileIndex % $numPools`
    echo $(date -u) "Pool index is ${poolIndex}"
    mailStoragePool=${mailStoragePool[${poolIndex}]}
    AIOstoragePool=$mailStoragePool
    echo $(date -u) "Storage Pool ${AIOstoragePool} used" |& tee -a $SCRIPT_LOG_FILE
  elif [[ $targetVM == *"web"* ]]; then
    tilenum=`expr substr ${1} 7 3`
    numPools=`expr $webLastPool + 1`
    tileIndex=`expr $tilenum + $numPools - 1`
    poolIndex=`expr $tileIndex % $numPools`
    echo $(date -u) "Pool index is ${poolIndex}"
    webStoragePool=${webStoragePool[${poolIndex}]}
    AIOstoragePool=$webStoragePool
    echo $(date -u) "Storage Pool ${AIOstoragePool} used" |& tee -a $SCRIPT_LOG_FILE
  elif [[ $targetVM == *"collab"* ]]; then
    tilenum=`expr substr ${1} 7 3`
    numPools=`expr $collabLastPool + 1`
    tileIndex=`expr $tilenum + $numPools - 1`
    poolIndex=`expr $tileIndex % $numPools`
    echo $(date -u) "Pool index is ${poolIndex}"
    collabStoragePool=${collabStoragePool[${poolIndex}]}
    AIOstoragePool=$collabStoragePool
    echo $(date -u) "Storage Pool ${AIOstoragePool} used" |& tee -a $SCRIPT_LOG_FILE
  fi

  sed -i -e "s/<Number-of-CPUS>[0-9]*/<Number-of-CPUS>$vCpuAIO/g" sampledata/vmAIO.xml

  ./vmdeploytocluster.pl --cluster $cluster --datastore $AIOstoragePool --server $mgmtServerIP \
     --customize_vm yes --filename sampledata/vmAIO.xml --schema schema/vm.xsd \
     --username $virtUser --password $virtPassword --templatename $templateName \
     --targetVM $targetVM --mac $macAddress |& tee -a $SCRIPT_LOG_FILE

 vm_present=$(/export/home/cp/config/workloads/specvirt/HV_Operations/vSphere/vmExist.sh $targetVM)
  if [[ $vm_present != "pass" ]]
  then
    if [ $retry -ge 5 ]
    then
      echo $(date -u) "Deployment of ${targetVM} failed. Exiting script" |& tee -a $SCRIPT_LOG_FILE
      exit 1
    fi
    echo $(date -u) "VM ${targetVM} failed to deploy. Sleeping for 15 seconds and retrying." |& tee -a $SCRIPT_LOG_FILE
    sleep 15
    echo $(date -u) "Redeploying " $targetVM |& tee -a $SCRIPT_LOG_FILE
    retry=`expr $retry + 1`
  fi
done

if [[ $targetVM == *"mail"* ]]; then
  ./vdiskcreate.pl --server $mgmtServerIP --username $virtUser --password $virtPassword --vmname $targetVM \
   --filename $targetVM-dbdisk.vmdk --disksize 10240 |& tee -a $SCRIPT_LOG_FILE

elif [[ $targetVM == *"web"* ]]; then
  ./vdiskcreate.pl --server $mgmtServerIP --username $virtUser --password $virtPassword --vmname $targetVM \
   --filename $targetVM-dbdisk.vmdk --disksize 20480 |& tee -a $SCRIPT_LOG_FILE

elif [[ $targetVM == *"collab"* ]]; then
  ./vdiskcreate.pl --server $mgmtServerIP --username $virtUser --password $virtPassword --vmname $targetVM \
   --filename $targetVM-dbdisk.vmdk --disksize 10240 |& tee -a $SCRIPT_LOG_FILE
fi

./PowerOnVM.sh $targetVM |& tee -a $SCRIPT_LOG_FILE

echo $(date -u) "DeployVM-AIO script for ${targetVM} Finished." |& tee -a $SCRIPT_LOG_FILE
