#!/bin/bash

###########################################################################
#                                                                         #
#  Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC). #
#  All rights reserved.                                                   #
#                                                                         #
###########################################################################

# DeployVM-BB.sh - use to deploy the BigBench VMs for a tile
#
# Adapted from /usr/lib/vmware-vcli/apps/vm/vmclone.pl for SPECvirt Datacenter (svdc)
#

if [ "$#" -ne 1 ]; then
   echo "Usage:  ./DeployVM-BB.sh <Tile# to deploy>"
   exit 1
fi

# Set up environment variables
. /export/home/cp/bin/getVars.sh
SCRIPT_LOG_FILE=/export/home/cp/log/${virtVendor}_scripts.log

echo $(date -u) "DeployVM-BB script for ${targetVM} started." |& tee -a $SCRIPT_LOG_FILE

generateMACs()
{
  zpt=`printf "%04d" $tilenum`
  tileMAC=${zpt:0:2}:${zpt:2:2}

  mac=(${MACAddressPrefix}${tileMAC}":08" ${MACAddressPrefix}${tileMAC}":09" ${MACAddressPrefix}${tileMAC}":10" ${MACAddressPrefix}${tileMAC}":11" ${MACAddressPrefix}${tileMAC}":12" ${MACAddressPrefix}${tileMAC}":13")
}

tilenum=$1
zpt3=`printf "%03d" $tilenum`
targetVM=(svdc-t${zpt3}-bbnn svdc-t${zpt3}-bbdn1 svdc-t${zpt3}-bbdn2 svdc-t${zpt3}-bbdn3 svdc-t${zpt3}-bbdn4 svdc-t${zpt3}-bbdb)
generateMACs

# bbnn  = 8 vCPU, 8 GB
# bbdnX = 8 vCPU, 24 GB
# bbdb  = 8 vCPU, 4 GB

sed -i -e "s/<Number-of-CPUS>[0-9]*/<Number-of-CPUS>$vCpuBBnn/g" sampledata/vmBBnn.xml
sed -i -e "s/<Number-of-CPUS>[0-9]*/<Number-of-CPUS>$vCpuBBdn/g" sampledata/vmBBdn.xml
sed -i -e "s/<Number-of-CPUS>[0-9]*/<Number-of-CPUS>$vCpuBBdb/g" sampledata/vmBBdb.xml

numPools=`expr $BBLastPool + 1`
tileIndex=`expr $tilenum + $numPools - 1`
poolIndex=`expr $tileIndex % $numPools`
BBstoragePool=${BBstoragePool[${poolIndex}]}
echo $(date -u) "Storage Pool ${BBstoragePool} used" |& tee -a $SCRIPT_LOG_FILE

for i in "${!targetVM[@]}"; do

  echo $(date -u) Deploying "${targetVM[$i]}" at MAC address "${mac[$i]}"|& tee -a $SCRIPT_LOG_FILE

  if [ $i -eq 0 ]; then
  ./vmdeploytocluster.pl --cluster $cluster --datastore $BBstoragePool --server $mgmtServerIP \
     --username $virtUser --password $virtPassword --customize_vm yes --filename sampledata/vmBBnn.xml --schema schema/vm.xsd \
     --templatename $templateName --targetVM "${targetVM[$i]}" --mac "${mac[$i]}" |& tee -a $SCRIPT_LOG_FILE
  fi

  if [ $i -ne 0 ] && [ $i -ne 5 ]; then
  ./vmdeploytocluster.pl --cluster $cluster --datastore $BBstoragePool --server $mgmtServerIP \
     --username $virtUser --password $virtPassword --customize_vm yes --filename sampledata/vmBBdn.xml --schema schema/vm.xsd \
     --templatename $templateName --targetVM "${targetVM[$i]}" --mac "${mac[$i]}" |& tee -a $SCRIPT_LOG_FILE
  fi

  if [ $i -eq 5 ]; then
  ./vmdeploytocluster.pl --cluster $cluster --datastore $BBstoragePool --server $mgmtServerIP \
     --username $virtUser --password $virtPassword --customize_vm yes --filename sampledata/vmBBdb.xml --schema schema/vm.xsd \
     --templatename $templateName --targetVM "${targetVM[$i]}" --mac "${mac[$i]}" |& tee -a $SCRIPT_LOG_FILE

  fi

  if [ $i -ne 0 ] && [ $i -ne 5 ]; then
     ./vdiskcreate.pl --server $mgmtServerIP --username $virtUser --password $virtPassword --vmname ${targetVM[$i]} --filename ${targetVM[$i]}-dbdisk --disksize 61440 |& tee -a $SCRIPT_LOG_FILE
  fi

done

echo; echo $(date -u) "Powering on VMs..."|& tee -a $SCRIPT_LOG_FILE
for i in "${!targetVM[@]}"; do
  ./PowerOnVM.sh ${targetVM[$i]} |& tee -a $SCRIPT_LOG_FILE
done

echo $(date -u) "DeployVM-BB script for ${targetVM} finished." |& tee -a $SCRIPT_LOG_FILE
