#!/bin/bash

###########################################################################
#                                                                         #
#  Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC). #
#  All rights reserved.                                                   #
#                                                                         #
###########################################################################

# DeployClient.sh - deploys a client to a client cluster with correct vCPU, memory, and MAC address settings
#
# Adapted from /usr/lib/vmware-vcli/apps/vm/vmclone.pl for SPECvirt Datacenter (svdc)
#

if [ "$#" -ne 1 ]; then
   echo "Usage:  ./DeployClient.sh <Tile# to deploy>"
   exit 1
fi

# Set up environment variables
. /export/home/cp/bin/getVars.sh
LOG_FILE=/export/home/cp/results/specvirt/$runfolder/prepSUT.log

generateMACs()
{
  zpt=`printf "%04d" $tilenum`
  tileMAC=${zpt:0:2}:${zpt:2:2}

  macAddress=(${MACAddressPrefix}${tileMAC}":20")
}

tilenum=$1
targetHost=$2
generateMACs
zpt3=`printf "%03d" $tilenum`

numPools=`expr $clientLastPool + 1`
tileIndex=`expr $tilenum + $numPools - 1`
poolIndex=`expr $tileIndex % $numPools`
clientStoragePool=${clientStoragePool[${poolIndex}]}

echo $(date -u) "Deploying svdc-t$zpt3-client on cluster $clientCluster to $clientStoragePool" |& tee -a $SCRIPT_LOG_FILE

  sed -i -e "s/<Number-of-CPUS>[0-9]*/<Number-of-CPUS>$vCpuClient/g" sampledata/vmclient.xml

  ./vmdeploytocluster.pl --cluster $clientCluster --datastore $clientStoragePool --server $mgmtServerIP  \
   --username $virtUser --password $virtPassword --customize_vm yes --filename sampledata/vmclient.xml \
   --schema schema/vm.xsd --templatename $clientTemplateName --targetVM svdc-t$zpt3-client --mac $macAddress

  sleep 2

  echo $(date -u) "Powering on svdc-t$zpt3-client ... " |& tee -a $SCRIPT_LOG_FILE
  ./PowerOnVM.sh "svdc-t$zpt3-client" 

echo $(date -u) "Deploying svdc-t$zpt3-client on cluster $clientCluster" |& tee -a $SCRIPT_LOG_FILE

