#!/bin/bash

###########################################################################
#                                                                         #
#  Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC). #
#  All rights reserved.                                                   #
#                                                                         #
###########################################################################

# DeployVM-ClientToHost.sh - deploys a client with correct vCPU, memory, and 
#      MAC address settings to a host
#
# Adapted from /usr/lib/vmware-vcli/apps/vm/vmclone.pl for SPECvirt Datacenter (svdc)
#

if [ "$#" -ne 3 ]; then
   echo "Usage:  ./DeployVM-ClientToHost.sh <Tile# to deploy> <hostName> <client storage pool>"
   exit 1
fi

# Set up environment variables
. /export/home/cp/bin/getVars.sh
LOG_FILE=/export/home/cp/results/specvirt/$runfolder/prepSUT.log

tilenum=$1
hostName=$2
poolName=$3

cd /export/home/cp/config/workloads/specvirt/HV_Operations/vSphere

generateMACs()
{
  zpt=`printf "%04d" $tilenum`
  tileMAC=${zpt:0:2}:${zpt:2:2}

  macAddress=(${MACAddressPrefix}${tileMAC}":20")
}

tilenum=$1
generateMACs
zpt3=`printf "%03d" $tilenum`

echo $(date -u) Deploying "svdc-t$zpt3-client" at MAC address "$macAddress" |& tee -a $SCRIPT_LOG_FILE

vmdeploy=$(./vmdeploytohost.pl --datastore $poolName --server $mgmtServerIP  \
   --username $virtUser --password $virtPassword --vmhost $hostName  \
   --customize_vm yes --filename sampledata/vmclient.xml --schema schema/vm.xsd \
   --templateName $clientTemplateName --targetVM svdc-t$zpt3-client)

if [[ $vmdeploy =~ "not found" ]]
then
   echo $(date -u) "ERROR: Host name doesn't exist. Retry with valid host name." ; echo |& tee -a $LOG_FILE
   exit 1
elif [[ $vmdeploy =~ "not available" ]]
then
   echo $(date -u) "ERROR: Storage pool doesn't exist. Retry with valid storage pool." ; echo |& tee -a $LOG_FILE
   exit 1
else 
   ./changeMAC.pl --server $mgmtServerIP --username $virtUser --password $virtPassword \
     --targetVM svdc-t$zpt3-client --mac $macAddress
   sleep 2
fi

./PowerOnVM.sh "svdc-t$zpt3-client" 

echo $(date -u) Deployed "svdc-t$zpt3-client" |& tee -a $SCRIPT_LOG_FILE

