#!/bin/bash

###########################################################################
#                                                                         #
#  Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC). #
#  All rights reserved.                                                   #
#                                                                         #
###########################################################################

# DeployVM-HDB.sh - use to deploy the HammerDB VMs for a tile
#
# Adapted from /usr/lib/vmware-vcli/apps/vm/vmclone.pl for SPECvirt Datacenter (svdc)
#

if [ "$#" -ne 1 ]; then
   echo "Usage:  ./DeployVM-HDB.sh <Tile# to deploy>"
   exit 1
fi

# Set up environment variables
. /export/home/cp/bin/getVars.sh
SCRIPT_LOG_FILE=/export/home/cp/log/${virtVendor}_scripts.log

generateMACs()
{
  zpt=`printf "%04d" $tilenum`
  tileMAC=${zpt:0:2}:${zpt:2:2}
  mac=(${MACAddressPrefix}${tileMAC}":06" ${MACAddressPrefix}${tileMAC}":07")
}

tilenum=$1
generateMACs
zpt3=`printf "%03d" $tilenum`

numPools=`expr $HDBLastPool + 1`
tileIndex=`expr $tilenum + $numPools - 1`
poolIndex=`expr $tileIndex % $numPools`
HDBstoragePool=${HDBstoragePool[${poolIndex}]}
echo $(date -u) "Storage Pool ${HDBstoragePool} used" |& tee -a $SCRIPT_LOG_FILE

echo $(date -u) Deploying "svdc-t$zpt3-hdb" at MAC address "${mac[0]}" |& tee -a $SCRIPT_LOG_FILE

sed -i -e "s/<Number-of-CPUS>[0-9]*/<Number-of-CPUS>$vCpuHdb/g" sampledata/vmHDB.xml
sed -i -e "s/<Number-of-CPUS>[0-9]*/<Number-of-CPUS>$vCpuHapp/g" sampledata/vmHapp.xml

  ./vmdeploytocluster.pl --cluster $cluster --datastore $HDBstoragePool --server $mgmtServerIP  \
   --username $virtUser --password $virtPassword --customize_vm yes --filename sampledata/vmHDB.xml --schema schema/vm.xsd \
   --templatename $templateName --targetVM svdc-t$zpt3-hdb --mac ${mac[0]} 

  ./vdiskcreate.pl --server $mgmtServerIP --username $virtUser --password $virtPassword --vmname svdc-t${zpt3}-hdb \
   --filename svdc-t${zpt3}-hdb-dbdisk --disksize 51200 

  ./PowerOnVM.sh "svdc-t$zpt3-hdb" 
echo $(date -u) Deployed "svdc-t$zpt3-hdb" |& tee -a $SCRIPT_LOG_FILE

echo $(date -u) Deploying "svdc-t$zpt3-happ" at MAC address "${mac[1]}"|& tee -a $SCRIPT_LOG_FILE

  ./vmdeploytocluster.pl --cluster $cluster --datastore $HDBstoragePool --server $mgmtServerIP  \
   --username $virtUser --password $virtPassword --customize_vm yes --filename sampledata/vmHapp.xml --schema schema/vm.xsd \
   --templatename $templateName --targetVM svdc-t$zpt3-happ --mac ${mac[1]} 

  ./PowerOnVM.sh "svdc-t$zpt3-happ" 

echo $(date -u) Deployed "svdc-t$zpt3-hdb" |& tee -a $SCRIPT_LOG_FILE

