#!/bin/bash

###########################################################################
#                                                                         #
#  Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC). #
#  All rights reserved.                                                   #
#                                                                         #
###########################################################################

#Script to activate a host machine
#
#$1 = hostName

# Set up environment variables
. /export/home/cp/bin/getVars.sh

SCRIPT_LOG_FILE=/export/home/cp/log/${virtVendor}_scripts.log

echo $(date -u) "ExitMaintenanceMode script for ${1} started." |& tee -a $SCRIPT_LOG_FILE

hostName=$1
cd /export/home/cp/config/workloads/specvirt/HV_Operations/vSphere

  ./hostops.pl --server $mgmtServerIP --username $virtUser --password $virtPassword --vihost $hostName --operation exit --mode ensure |& tee -a $SCRIPT_LOG_FILE

echo $(date -u) "ExitMaintenanceMode script completed." |& tee -a $SCRIPT_LOG_FILE

