#!/bin/bash

###########################################################################
#                                                                         #
#  Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC). #
#  All rights reserved.                                                   #
#                                                                         #
###########################################################################

# PowerOffAllTiles.sh - powers off all workload VMs on the SUT cluster
#
# Set up environment variables
. /export/home/cp/bin/getVars.sh

echo "Powering off all workload VMs on cluster $cluster..."
./PowerOffAllTiles.pl --server $mgmtServerIP --username $virtUser --password=$virtPassword --cluster $cluster 

status=$?
if [ $status -eq 0 ] ; then 
 echo  SUCCESS.
else
 echo FAILED. $status VMs not powered-off
fi
exit $status 
