#!/bin/bash

###########################################################################
#                                                                         #
#  Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC). #
#  All rights reserved.                                                   #
#                                                                         #
###########################################################################

#Script to power on a VM
#
#$1 = targetVM


# Set up environment variables
. /export/home/cp/bin/getVars.sh
SCRIPT_LOG_FILE=/export/home/cp/log/${virtVendor}_scripts.log

cd /export/home/cp/config/workloads/specvirt/HV_Operations/vSphere

targetVM=$1
echo $(date -u) "PowerOn script for ${targetVM} started" |& tee -a $SCRIPT_LOG_FILE

  ./vmcontrol.pl --server $mgmtServerIP --username $virtUser --password $virtPassword --vmname $targetVM --operation poweron |& tee -a $SCRIPT_LOG_FILE

getstate=1
pingcount=0

# Ping to check if VM is up

while [ $getstate -ne "0" ]
do
   ping -q -c 1 -t 1 $targetVM &> /dev/null; getstate=$?; pingcount=`expr $pingcount + 1`; sleep 1
   if [ $pingcount -ge "60" ]
      then
      echo $(date -u) "Unable to ping ${targetVM}. PowerOn failed" |& tee -a $SCRIPT_LOG_FILE
      exit 1
   fi

done

echo $(date -u) "${targetVM} running. PowerOn succeeded." |& tee -a $SCRIPT_LOG_FILE

