#!/bin/bash

###########################################################################
#                                                                         #
#  Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC). #
#  All rights reserved.                                                   #
#                                                                         #
###########################################################################

# Set up environment variables
. /export/home/cp/bin/getVars.sh

runfolder=`ls -l /export/home/cp/results/specvirt|grep ^d|awk '{print $9}'|egrep '^[0-9]{4}-[0-9]{2}-[0-9]{2}_[0-9]{2}-[0-9]{2}-[0-9]{2}'|tail -1`
mkdir -p /datastore/tmp
tmpdir=/datastore/tmp
LOG_FILE=/export/home/cp/results/specvirt/$runfolder/collectSupport.log

cd $tmpdir

# Copy reporterHelper.sh to SUT hosts and invoke reporter.sh to collect hypervisor support files for submission
echo $(date -u) "Invoking reporter to create supporting tarballs for result ${runfolder}." |& tee -a $LOG_FILE

wtime=560
elapsed=0
bgstatus=0
pidlist=()
for i in $(seq 1 $numHosts)
  do
      setsid /export/home/cp/config/workloads/specvirt/HV_Operations/vSphere/reporter.sh sutHost$i & 
	pidlist+=($!)
	# echo debug: pid = $!
  done
running=${#pidlist[@]}

while [ "$running" -ge 1 ]
 do
    sleep 10
    elapsed=$((elapsed+10))
    
    # check if any of the processes are still running
    running=`ps -o pid= -p ${pidlist[@]} |wc -l`

    # If elapsed time has exceeded wait time and there are still
    # processes running, kill off remaing processes via pgrp
    if [ $elapsed -ge $wtime ] && [ $running -ge 1 ]
    then
        for i in ${pidlist[@]}
        do
	  if [ `ps -o pgrp= -p $i |wc -w` -eq 1 ]
	  then 
	  	kill -TERM -- -$i >/dev/null 2>&1
	  fi
	done
        # check if any process is still running and 
	# print warning message
	sleep 2
        running=`ps -o pid= -p ${pidlist[@]} |wc -l` 
	if [ $running -ne 0 ]
	then
                echo $(date -u) "Timer expired, reporter processes may not have terminated. Please rerun manually. " |& tee -a $LOG_FILE
        else
                echo $(date -u) "Timer expired, reporter processes. Please rerun manually. " |& tee -a $LOG_FILE
    	fi
	bgstatus=1
	break
    fi
  done

echo bgstatus is $bgstatus

if [ $bgstatus -eq 0 ] 
  then
  cd /export/home/cp/results/specvirt/$runfolder; mkdir -p support
  mv -v /datastore/tmp/* support
  tar czf ../$runfolder.tgz .
  mv ../$runfolder.tgz .
fi

echo; echo
echo $(date -u) "Include /export/home/cp/results/specvirt/$runfolder.tgz with your benchmark submission."|& tee -a $LOG_FILE
echo; echo $(date -u) "collectSupport.sh complete." |& tee -a $LOG_FILE

