#!/usr/bin/perl -w
# William Lam 
# 08/18/09
# http://engineering.ucsb.edu/~duonglt/vmware

use strict;
use warnings;
use VMware::VILib;
use VMware::VIRuntime;
use VMware::VIExt;

my %opts = (
   cluster => {
      type => "=s",
      help => "Name of Cluster ",
      required => 1,
   },
);

Opts::add_options(%opts);
Opts::parse();
Opts::validate();
Util::connect();

my $cluster = Opts::get_option('cluster');
my ($cluster_view,$host_views,$vms);

$cluster_view = Vim::find_entity_view(view_type => 'ClusterComputeResource', filter => { name => $cluster});

unless($cluster_view) {
  die "Unable to locate cluster name \"$cluster\"!";
}

#print "Cluster: " . $cluster_view->name . "\n";

$host_views = Vim::get_views(mo_ref_array => $cluster_view->host);
foreach(@$host_views) {
    print "" . $_->name . "\n";
} 

Util::disconnect();

