#!/bin/sh 
#
#  Adapted for SPECvirt Datacenter 2021
#
#  reporterHelper.sh - Called by reporter.sh on the svdc-director VM.
#
#  DO NOT RUN DIRECTLY svdc-director
#
#    This file is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License, Version 2.0, 
#    as published by the Free Software Foundation. 
#
#    This file is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with the VMmark Harness; if not, write to the Free Software 
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA#
# --------------------------------------------------------------------------------
# 11032018

#HOSTTYPE = "sut"

###############################################################################
# Functions
###############################################################################

startReporterV65 () # codepath for 6.5 and later
{
   /usr/lib/vmware/osfs/bin/osfs-mkdir $REPORTDIR    
   mkdir -pm 755 $WORKDIR
   mkdir -pm 755 $VMSUPPORTTEMPDIR
   
   if [ ! -d "$WORKDIR" ] ; then
     printf "\nUnable to create working directory $WORKDIR. Please contact SPECvirt Support.\n"
     exit;
  fi
   
   ############################################################################
   # Collect vm-support file
   ############################################################################

#   if [ "$HOSTTYPE" = "sut" ] ; then
      # Exclude specific manifests specified below from vm-support execution for the sut.
      OUTPUTSTR=$(vm-support -e "System:Base Logs:System VirtualMachines:logs System:VMKernel_Cores System:CoreDumps Storage:VSANTraces Storage:VSANHealth Storage:VSAN" -w $VMSUPPORTTEMPDIR |tail -1)
#   elif [ "$HOSTTYPE" = "client" ] ; then
      # Client reporter bundle includes only specific manifests specified below, not defaults.
#      OUTPUTSTR=$(vm-support -a "VirtualMachines:base VirtualMachines:diskinfo System:NTP Benchmark:vmmark-client" -w $VMSUPPORTTEMPDIR |tail -1)
#   else
#      exit 1;
#   fi
   # Extract vm-support filename from vm-support output string
   VMSUPPORTFILE=$(echo ${OUTPUTSTR#T*$VMSUPPORTTEMPDIR\/} | sed 's/.$//')
   VMSUPPORTDIR=$(echo ${VMSUPPORTFILE%\.tgz}) # This is the name of the directory that will be created when vm-support is unzipped.
   
   ############################################################################
   # Extract and reconstruct vm-support file
   ############################################################################

   vm-support --extract $VMSUPPORTTEMPDIR/$VMSUPPORTFILE $VMSUPPORTTEMPDIR
   rm -f $VMSUPPORTTEMPDIR/$VMSUPPORTFILE
   
   ############################################################################
   # PostProcess vm-support file
   ############################################################################
   cd $VMSUPPORTTEMPDIR/$VMSUPPORTDIR # cd into newly extracted file
   
   # Change all UUID in /vmfs/volumes directory names to Volume Name instead
   # parse Volume names vs UUID
   localcli storage vmfs extent list | sed '1,2d' | while read LINE ; do
     VOLNAME=$(echo $LINE | awk {'print $1'})
      # sed command: make sure expected UUID matches 8-8-4-12 character pattern. Error checks in case volume name has a space.
      UUID=$(echo $LINE | awk {'print $2'} | sed '/^[0-9,a-f]\{8\}-[0-9,a-f]\{8\}-[0-9,a-f]\{4\}-[0-9,a-f]\{12\}/!d')      
      # if UUID fits UUID format,
      if [ "$UUID" ] ; then
         ls vmfs/volumes 2> /dev/null | while read DIRNAME ; do
            if [ "$DIRNAME" = "$UUID" ] ; then
              if [[ "$VMSUPPORTDIR" && "$VMSUPPORTTEMPDIR" ]] ; then   # confirm that these variables are not empty before issuing file commands
             mkdir $VMSUPPORTTEMPDIR/$VMSUPPORTDIR/vmfs/volumes/$VOLNAME 2> /dev/null # if VOLNAME already exists, this will throw back an error, so ignore it.
                 mv $VMSUPPORTTEMPDIR/$VMSUPPORTDIR/vmfs/volumes/$DIRNAME/* $VMSUPPORTTEMPDIR/$VMSUPPORTDIR/vmfs/volumes/$VOLNAME 2> /dev/null 
             rm -rf $VMSUPPORTTEMPDIR/$VMSUPPORTDIR/vmfs/volumes/$DIRNAME
            else
               printf "Unable to rename LUN names.\n" 
           fi
            fi
       done
      fi
   done
   #
   # Create list of all running VMs, and any templates
   #
   VMID=$(vim-cmd vmsvc/getallvms 2>/dev/null | awk '$1 ~ /^[0-9]+$/ {print $1}')
   echo Powered on VMs are > commands/all-powered-on-VMs.txt
   echo Template VMs are > commands/all-template-VMs.txt
   for i in $VMID; do
   STATE=$(vim-cmd vmsvc/power.getstate $i 2>/dev/null | tail -1 | awk '{print $2}')
      if [[ "$STATE" = "on" ]] ; then
       VMNAME=$(vim-cmd vmsvc/get.summary $i 2>/dev/null | grep name | awk '{print $3}' | sed 's/\"\|,//g')
         if [[ $VMNAME ]] ; then
      echo $VMNAME >> commands/all-powered-on-VMs.txt
     fi
      elif [[ "$STATE" = "off" ]] ; then
      # If VM just got migrated off this host, $STATE will not be on or off. We cannot retrieve its data, like VMPATH. Cannot delete VMDIR.
      # In this case, we may find directories for the migrated VM remaining in /vmfs/volumes/
     VMPATH=$(vim-cmd vmsvc/getallvms 2>/dev/null | grep "^$i\>" | sed -e 's/^.* \[.*] //' -e 's/.vmx.*$/.vmx/') # sed captures VM folder names with spaces in them
     VMDIR=$(dirname "$VMPATH" 2>/dev/null) 
     VMLUN=$(vim-cmd vmsvc/getallvms 2>/dev/null | grep "^$i\>" | sed -e 's/^.*\[//' -e 's/\].*//')
     if [[ "$VMSUPPORTTEMPDIR" && "$VMSUPPORTDIR" && "$VMLUN" && "$VMDIR" ]] ; then   # confirm that these variables are not empty before issuing rm command
      case $VMDIR in
          *template*) TEMPLATE=$VMDIR; echo $TEMPLATE >> commands/all-template-VMs.txt ;; # don't delete templates
          *) rm -r "$VMSUPPORTTEMPDIR/$VMSUPPORTDIR/vmfs/volumes/$VMLUN/$VMDIR" ;; # otherwise, delete the powered off VM's files
      esac
     else
        printf "Unable to remove powered off VM files from "$VMSUPPORTDIR/vmfs/volumes/$VMLUN/$VMDIR".\n"
     fi
      fi
   done  
   if [ "$VMNAME" = "" ] ; then
    echo No VMs are powered on. > commands/all-powered-on-VMs.txt
   fi
   if [ "$TEMPLATE" = "" ] ; then
    echo No templates are on this host. > commands/all-template-VMs.txt
   fi
   if [[ "$VMSUPPORTTEMPDIR" && "$VMSUPPORTDIR" ]] ; then
      find "$VMSUPPORTTEMPDIR/$VMSUPPORTDIR/vmfs/volumes/" -type d -exec rmdir {} + 2>/dev/null # remove empty volume directories
  else
      printf "Unable to remove empty directories.\n"
  fi
   cd ../   # Puts us in $VMSUPPORTTEMPDIR
   # Change default vm-support name to friendly SUBMITDIR name.
   mv $VMSUPPORTDIR/* ../$SUBMITDIR 
   cd ../ # Puts us in $REPORTDIR
   tar -czf ${SUBMITDIR}.tgz $SUBMITDIR  # Zip directory SUBMITDIR into a tgz named WORKDIR_hostfiles.tgz located in REPORTDIR
   
  rm -rf $SUBMITDIR 2>/dev/null # Remove unzipped vm-support copy
  rm -rf $VMSUPPORTTEMPDIR 2>/dev/null
   # Publish location of reporter tgz file for calling scripts & harness
   printf "$REPORTDIR/$SUBMITDIR.tgz\n" >> /tmp/ResultsPath.txt 2>/dev/null

}

startReporterV5 () # codepath for prior to 6.5
{
  mkdir -pm 755 $WORKDIR
  mkdir -pm 755 $VMSUPPORTTEMPDIR
  
  if [ ! -d "$WORKDIR" ] ; then
     printf "\nUnable to create working directory $WORKDIR. Please contact SPECvirt Support.\n"
     exit;
  fi
  
   ############################################################################
   # Collect vm-support file
   ############################################################################

   # Exclude System:Base, Logs:System, System:VMKernel_Cores and VirtualMachines:logs from vm-support execution for the sut.
   # These manifests are replaced by vmmark3-sut.mfx which has already been transferred to the host by VMmark-Reporter.
   # vmmark3 manifests are run by default and do not have to be specified in the vm-support command.
   # Client reporter bundle includes only the VirtualMachines:base and custom Benchmark:vmmark-client manifests, not default manifests.
  # Put vm-support tgz in a temp directory because filename is not unique enough.
#   if [ "$HOSTTYPE" = "sut" ] ; then
      OUTPUTSTR=$(vm-support -e "System:Base Logs:System VirtualMachines:logs System:VMKernel_Cores" -w $VMSUPPORTTEMPDIR |tail -1)
#   elif [ "$HOSTTYPE" = "client" ] ; then
#      OUTPUTSTR=$(vm-support -a "VirtualMachines:base Benchmark:vmmark-client" -w $VMSUPPORTTEMPDIR |tail -1)
#   else exit 1;   
#   fi
   rm -f /etc/vmware/vm-support/vmmark3-sut.mfx
   rm -f /etc/vmware/vm-support/vmmark3-client.mfx  
   # Extract vm-support filename from vm-support output string
   VMSUPPORTFILE=$(echo ${OUTPUTSTR#T*$VMSUPPORTTEMPDIR\/} | sed 's/.$//')
   VMSUPPORTDIR=$(echo ${VMSUPPORTFILE%\.tgz}) # This is the name of the directory that will be created when vm-support is unzipped.
   
   ############################################################################
   # Collect add'l files from host for inclusion in reporter file
   ############################################################################
   cd $WORKDIR
   mkdir commands etc
   mkdir etc/vmware
   #
   # Getting list of all running VM guests
   #
   VMID=$(vim-cmd vmsvc/getallvms 2>/dev/null | awk '$1 ~ /^[0-9]+$/ {print $1}')          
   echo Powered on VMs are > commands/all-powered-on-VMs.txt
   for i in $VMID; do
   STATE=$(vim-cmd vmsvc/power.getstate $i 2>/dev/null | tail -1 | awk '{print $2}')
      if [[ "$STATE" = "on" ]] ; then    
       VMNAME=$(vim-cmd vmsvc/get.summary $i 2>/dev/null | grep name | awk '{print $3}' | sed 's/\"\|,//g')
         if [[ $VMNAME ]] ; then 
      echo $VMNAME >> commands/all-powered-on-VMs.txt 
     fi
      elif [[ "$STATE" = "off" ]] ; then    
      # If VM just got migrated off this host, $STATE will not be on or off. We cannot retrieve its data, like VMPATH. Cannot delete VMDIR.
     # In this case, we may find directories for the migrated VM remaining in /vmfs/volumes/
     VMPATH=$(vim-cmd vmsvc/getallvms 2>/dev/null | grep "^$i\>" | sed -e 's/^.* \[.*] //' -e 's/.vmx.*$/.vmx/') # sed captures VM folder names with spaces in them
     VMDIR=$(dirname "$VMPATH" 2>/dev/null) 
     VMLUN=$(vim-cmd vmsvc/getallvms 2>/dev/null | grep "^$i\>" | sed -e 's/^.*\[//' -e 's/\].*//')
     if [[ "$VMSUPPORTDIR" && "$VMLUN" && "$VMDIR" ]] ; then   # confirm that these variables are not empty before issuing rm command
          echo "rm -rf \"$VMSUPPORTDIR/vmfs/volumes/$VMLUN/$VMDIR\"" >> /tmp/ResultsPath.txt
       else
        printf "Unable to remove powered off VM files from "$VMSUPPORTDIR/vmfs/volumes/$VMLUN/$VMDIR".\n"
     fi
      fi
   done  
   if [ "$VMNAME" = "" ] ; then
    echo No VMs are powered on. > commands/all-powered-on-VMs.txt
   fi
   
   cd ../   # Puts us in $REPORTDIR
   tar -czf ${WORKDIR}_hostfiles.tgz $SUBMITDIR   # Zip directory SUBMITDIR into a tgz named WORKDIR_hostfiles.tgz located in REPORTDIR
   # WORKDIR_hostfiles.tgz is the zipfile of miscellaneous host files that is transferred to client, then unzipped and integrated
   rm -rf $WORKDIR # Remove temporary directory
  
   # Publish location of reporter tgz file for calling scripts & VMmark harness
   printf "$VMSUPPORTTEMPDIR/$VMSUPPORTFILE\n" >> /tmp/ResultsPath.txt 2>/dev/null
   printf "$REPORTDIR/${SUBMITDIR}_hostfiles.tgz\n" >> /tmp/ResultsPath.txt 2>/dev/null
}

###############################################################################
# MAIN
# Shared code for all ESX versions.
###############################################################################
# cleanup old temporary variables from unclean exit
rm -f /tmp/ResultsPath.txt 2>/dev/null
RAND=$(date +"%N" | cut -c 1-7)
DATE=$DATE$RAND
if [[ "$RAND" != "%N" ]] ; then  
   DATE=$(date +"%Y%m%d-%H%M")$RAND
else # ESXi 5.x does not support generating random numbers using %N. Use a different way to generate random numbers.
   RAND1=$(</dev/urandom sed 's/[^[:digit:]]\+//g' | head -c3 2>/dev/null)
   RAND2=$(</dev/urandom sed 's/[^[:digit:]]\+//g' | head -c3 2>/dev/null)
   RAND1="${RAND1%\\n}"
   RAND2="${RAND2%\\n}"
   RAND=$(echo $RAND1$RAND2 | sed s/\ // | cut -c 1-2)
   DATE=$(date +"%Y%m%d-%H%M")$RAND 
fi
#
#Choose LUN for reporting directory that has enough disk space for the reporter file.
# 
REPORTDIR=/vmfs/volumes/$(ls /vmfs/volumes 2>/dev/null |grep -v " "|sort -u |tail -1)/reporter-$DATE # backup lun in case all other luns fail requirements
LUNS=$(df -m | awk '{print $4 $6 $7}' | sed '1d') # Lists space free on volume in MB.
TESTFILE=testfile$RAND

for i in $LUNS; do
   LUN=$(echo $i | sed 's/^.*\/vmfs\/volumes\///')
   MBFREE=$(echo ${i%%\/*})
   # Test there are no spaces in lun name
   if [ "$(ls /vmfs/volumes 2>/dev/null | grep "$LUN" | grep -v " ")" != "" -a "$LUN" != "" ] ; then
      cd /vmfs/volumes/$LUN 2>/dev/null
      # Test writeability of LUN
      touch $TESTFILE 2>/dev/null
      if [ $? -eq 0 ] ; then # if touch completed successfully
         if [ -z $REPORTDIR ] ; then # backup reporter directory has not been chosen
            # This lun passes our two requirements - writable and no spaces. If we are unable to find a lun that passes space free, fall back on this one.
            REPORTDIR=/vmfs/volumes/$LUN/reporter-$DATE 
         fi
         if [ -e $TESTFILE ] ; then
            rm -f $TESTFILE 2>/dev/null
            cd - >/dev/null            
            # Test adequate free space on LUN
            if [ "$MBFREE" -gt 30000 ] ; then # Ensure that LUN has at least 30,000 MB (29.3GB) of space free for reporter file(s).
               REPORTDIR=/vmfs/volumes/$LUN/reporter-$DATE          
               # Test whether another reporter directory exists on this lun
               if [ "$LUN" != "" ] && [ -z "$(find /vmfs/volumes/$LUN/ -name "reporter*" -type d)" ] ; then
                  REPORTDIR=/vmfs/volumes/$LUN/reporter-$DATE
                  break
               fi
            fi
         fi
      fi
  fi
done

# Select name for reporter package filename.
HOSTNAME=$(hostname -s 2>/dev/null)
# If hostname is localhost, use IP address passed from primeclient
if [ "$HOSTNAME" = "localhost" ] ; then
  HOSTNAME=$3
fi

# Append two random numbers to working directory name in case of hostname conflict. 
RAND=$(date +"%N" | cut -c 1-2)

if [[ "$RAND" != "%N" ]] ; then  
  DATE=$(date +"%Y%m%d-%H%M")$RAND
  # If there is a conflict in hostnames and random numbers, add more random numbers to filename 
  if [ -d $REPORTDIR/$HOSTNAME-$DATE ] ; then
      RAND=$(date +"%N" | cut -c 1-7)
      DATE=$DATE$RAND
  fi
else # ESXi 5.x does not support generating random numbers using %N. Use a different way to generate random numbers.
  RAND1=$(</dev/urandom sed 's/[^[:digit:]]\+//g' | head -c3 2>/dev/null)
  RAND2=$(</dev/urandom sed 's/[^[:digit:]]\+//g' | head -c3 2>/dev/null)
  RAND1="${RAND1%\\n}"
  RAND2="${RAND2%\\n}"
  RAND=$(echo $RAND1$RAND2 | sed s/\ // | cut -c 1-2)
  DATE=$(date +"%Y%m%d-%H%M")$RAND 
  if [ -d $REPORTDIR/$HOSTNAME-$DATE ] ; then
      RAND1=$(</dev/urandom sed 's/[^[:digit:]]\+//g' | head -c3 2>/dev/null)
      RAND2=$(</dev/urandom sed 's/[^[:digit:]]\+//g' | head -c3 2>/dev/null)
      RAND1="${RAND1%\\n}"
      RAND2="${RAND2%\\n}"
      RAND=$(echo $RAND1$RAND2 | sed s/\ // | cut -c 1-2)
      DATE=$DATE$RAND      
  fi
fi
SUBMITDIR=$HOSTNAME-$DATE
SUBMITFILE=$HOSTNAME-$DATE.tgz

WORKDIR=$REPORTDIR/$SUBMITDIR
VMSUPPORTTEMPDIR=$REPORTDIR/vm-support-$SUBMITDIR

###############################################################################
###############################################################################

startReporterV65

###############################################################################
###############################################################################

exit;

