#!/bin/sh
#
# Set up passwordless login in SUT hosts
# 
# Before running this script, make sure to update /etc/hosts with hostname aliases for 
#   SUT online and offline hosts as well as client hosts.
#
# For example:
#
#  12.22.0.11  sutHost1
#  12.22.0.12  sutHost2
#  12.22.0.13  sutHost3
#  12.22.0.14  sutHost4 offline_host1
#
# Optionally you can add aliases for the client hosts:
# 
#  12.22.0.21  clientHost1
#  12.22.0.22  clientHost2
 
# Get environment variables
. /export/home/cp/bin/getVars.sh

echo "Enabling password-less login to SUT hosts"; echo
for Host in `grep Host /etc/hosts | awk '{print $1}'`
do
      echo "Processing host ${Host}"
      cat ~/.ssh/id_rsa.pub | ssh $Host 'cat >> /etc/ssh/keys-root/authorized_keys'
      ssh $Host 'chmod +t /etc/ssh/keys-root/authorized_keys'
      ssh $Host '/etc/init.d/SSH restart'
done
echo; echo "Password-less login to SUT hosts enabled"
# 
