#!/bin/sh
#
# startesxtop.sh - vSphere esxtop initialization script 
#
#   $CP_BIN/Control.config defines:
#     - $mailStoragePool[0] as the default storage target for esxtop batch files.
#         You can change the value of $LUN to use your persistent shared LUN and directory
#         (for example "/vmfs/volumes/LUN6")
#     - $offlineHost_X as the host(s) in maintenance mode
#
#  Requirements:
#
#  1. Make sure you define all ONLINE cluster hosts with an alias starting with the string "sutHost".
#       Edit /export/home/cp/bin/hosts.txt to add each sutHost and its IP address. For example:
#           172.23.0.11   sutHost1
#           172.23.0.12   sutHost2
#           172.23.0.13   sutHost3
#           172.23.0.14   sutHost4 offlineHost_1
#
#  2. Make sure you define all MAINTENANCE MODE hosts in /export/home/cp/bin/Control.config:
#           offlineHost_1 = 172.23.0.14
#
#  If you make changes to hosts.txt and/or Control.config, rerun /export/home/cp/bin/genConfig.sh
#

. /export/home/cp/bin/getVars.sh
SCRIPT_LOG_FILE=/export/home/cp/log/${virtVendor}_scripts.log

echo $(date -u) "Starting esxtop collection ..." |& tee -a $SCRIPT_LOG_FILE

# Select a shared storage pool available to SUT hosts. For example, to use the storage pool assigned to mail: 
LUN=${mailStoragePool[0]}

ssh sutHost1 "if [ ! -d /vmfs/volumes/$LUN/SVDCperf ]; then mkdir -p /vmfs/volumes/$LUN/SVDCperf; fi "
if [ "$?" != "0" ]; then
    echo $(date -u) "ERROR: Could not create target directory for esxtop files! Exiting" |& tee -a $SCRIPT_LOG_FILE
    exit 1
fi

sleep 2
# Start esxtop on online cluster hosts
for sutHost in `grep sutHost /etc/hosts | awk '{print $1}'|grep -v ^#`
do
   echo $(date -u) "Starting esxtop in batch mode on $sutHost ... " |& tee -a $SCRIPT_LOG_FILE
   ssh $sutHost "nohup esxtop -b -d 10 -n 1080 > /vmfs/volumes/$LUN/SVDCperf/$sutHost-esxtop.csv &" & 
done

