#!/bin/sh
#
# stopesxtop.sh - vSphere esxtop stop script
#
# Follow instructions in startesxtop.sh

. /export/home/cp/bin/getVars.sh
SCRIPT_LOG_FILE=/export/home/cp/log/${virtVendor}_scripts.log

# Use the same LUN in startesxtop.sh
LUN=${mailStoragePool[0]}

runfolder=`ls -l /export/home/cp/results/specvirt|grep ^d|awk '{print $9}'|egrep '^[0-9]{4}-[0-9]{2}-[0-9]{2}_[0-9]{2}-[0-9]{2}-[0-9]{2}'|tail -1`
if [ -f /export/home/cp/results/specvirt/$runfolder/perf/$runfolder-esxtop.tgz ]; then
   mv /export/home/cp/results/specvirt/$runfolder/perf/$runfolder-esxtop.tgz /export/home/cp/results/specvirt/$runfolder/perf/$runfolder-esxtop.tgz_prior
fi

# Stop esxtop on online cluster hosts
for sutHost in `grep sutHost /etc/hosts | awk '{print $1}'i|grep -v ^#`
do
   echo $(date -u) "Stopping esxtop on $sutHost ... " |& tee -a $SCRIPT_LOG_FILE
   ssh $sutHost "pkill esxtop"
   ssh $sutHost "pkill esxtop"
done

sleep 10

## Copy perf collector output CSV files from offline host
cd $CP_RESULTS/$runfolder
echo $(date -u) "Bundling up and copying esxtop output to $CP_RESULTS/$runfolder/perf ... " |& tee -a $SCRIPT_LOG_FILE
mkdir -p perf; cd perf
ssh sutHost1 "cd /vmfs/volumes/$LUN/SVDCperf; tar -czf $runfolder-esxtop.tgz *esxtop.csv"
scp -p sutHost1:/vmfs/volumes/$LUN/SVDCperf/$runfolder-esxtop.tgz /export/home/cp/results/specvirt/$runfolder/perf

## Optional clean up keeping current CSV and tgz files and deleting all others
#ssh sutHost1 "ls -lQ /vmfs/volumes/$LUN/*.csv | grep -v '$runfolder' | rm -f"
#ssh sutHost1 "ls -lQ /vmfs/volumes/$LUN/*.tgz | grep -v '$runfolder' | rm -f"

echo $(date -u) "esxtop stopped " |& tee -a $SCRIPT_LOG_FILE 
