#!/bin/bash

###########################################################################
#                                                                         #
#  Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC). #
#  All rights reserved.                                                   #
#                                                                         #
###########################################################################

#Script to get SUT details - at the beginning (0) and end (1) of benchmark run 

if [ "$#" -ne 1 ]; then
   echo "Usage:./sutConfig.sh <0/1>"
   exit 1
fi

# Set up environment variables
. /export/home/cp/bin/getVars.sh

# Get most recent results directory name
runfolder=`ls -l /export/home/cp/results/specvirt|grep ^d|awk '{print $9}'|egrep '^[0-9]{4}-[0-9]{2}-[0-9]{2}_[0-9]{2}-[0-9]{2}-[0-9]{2}'|tail -1`
mkdir -p /export/home/cp/results/specvirt/$runfolder/config
LOG_FILE=/export/home/cp/results/specvirt/${runfolder}/config/sutConfig.log

cd /export/home/cp/results/specvirt/$runfolder/config

# Start of measurement interval called by startRun.sh
if [ $1 = "0" ]
  then
  echo $(date -u) "Creating start of run config files for result ${runfolder}." |& tee $LOG_FILE
  /export/home/cp/config/workloads/specvirt/HV_Operations/vSphere/sutConfig.pl --server $mgmtServerIP --username $virtUser --password $virtPassword \
     --cluster $cluster --clientcluster $clientCluster > startRun.config
  testStartDate=$(date -u +%Y-%m-%dT%T)
  echo Benchmark.test.start=$testStartDate >> startRun.config
  exit 0

# End of measurement interval called by endRun.sh
else [ $1 = "1" ]
  echo $(date -u) "Creating end of run config files for result ${runfolder}." |& tee $LOG_FILE
  /export/home/cp/config/workloads/specvirt/HV_Operations/vSphere/sutConfig.pl --server $mgmtServerIP --username $virtUser --password $virtPassword \
     --cluster $cluster --clientcluster $clientCluster > endRun.config
  testEndDate=$(date -u +%Y-%m-%dT%T)
  echo Benchmark.test.end=$(date -u +%Y-%m-%dT%T) >> endRun.config

# Start processing from [start,end]Run.config
  if [[ ! -f startRun.config ]] || [[ ! -f endRun.config ]]; then
    echo "Problem with startRun.config and/or endRun.config. Contact SPECvirt support." |& tee $LOG_FILE
    exit 1
  else
# Get SUT.VM.migration.total from *Run.config
    startTotal=($( grep runningTotal startRun.config | cut -d "=" -f2 ) )
    endTotal=($( grep runningTotal endRun.config | cut -d "=" -f2 ) )

    let totalMigrated=endTotal-startTotal
    echo SUT.VM.migration.total=$totalMigrated >> endRun.config

    sed -i '/runningTotal/d' *Run.config

    echo $(date -u) "Collecting SUT configuration report files for result ${runfolder}." |& tee $LOG_FILE
    /export/home/cp/config/workloads/specvirt/HV_Operations/vSphere/vSphereHealthCheck-v7.pl --server $mgmtServerIP \
        --username $virtUser --password $virtPassword --type cluster --cluster $cluster --printerfriendly yes --report SUTConfig.html

    echo $(date -u) "Collecting SUT events report for result ${runfolder}." |& tee $LOG_FILE
    echo "===========" > SUTConfig.out
    echo "vSphere Events:" >> SUTConfig.out
    echo "===========" >> SUTConfig.out
    # Get test start time from startRun.config
    testStartDate=$(grep start startRun.config | cut -d "=" -f2)
    /export/home/cp/config/workloads/specvirt/HV_Operations/vSphere/getEvents.pl --server $mgmtServerIP \
      --username=$virtUser --password=$virtPassword --testbegin $testStartDate --testend $testEndDate | sort -u >> SUTConfig.out

   fi 
fi
echo $(date -u) "sutConfig.sh complete." |& tee -a $LOG_FILE
