#!/bin/sh

###########################################################################
#                                                                         #
#  Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC). #
#  All rights reserved.                                                   #
#                                                                         #
###########################################################################

# userInit.sh - User-defined initialization script for vSphere
#
# This script assumes you configured passwordless login from the svdc-director VM to 
#  each of the SUT hosts when you ran makeme_svdc-director.sh. 

# Set up environment variables
. /export/home/cp/bin/getVars.sh
SCRIPT_LOG_FILE=/export/home/cp/log/${virtVendor}_scripts.log

echo $(date -u) "userInit.sh started"|& tee -a $SCRIPT_LOG_FILE

## Stop esxtop on each cluster host
#for sutHost in `grep sutHost /etc/hosts | awk '{print $1}'|grep -v ^#`
#do
#   echo $(date -u) "Stopping esxtop on $sutHost ... " |& tee -a $SCRIPT_LOG_FILE
#   ssh $sutHost "pkill esxtop"
#   ssh $sutHost "pkill esxtop"
#done

## Include full path to script
#echo $(date -u) "Starting performance data collectors ..." |& tee -a $SCRIPT_LOG_FILE
#/export/home/cp/config/workloads/specvirt/HV_Operations/vSphere/startesxtop.sh &

echo $(date -u) "userInit.sh finished" |& tee -a $SCRIPT_LOG_FILE
