#!/usr/bin/perl -w
#
# Copyright (c) 2007 VMware, Inc.  All rights reserved.
# Copyright (c) 2013 David Pasek   All rights reserved.

use strict;
use warnings;

use FindBin;
use lib "$FindBin::Bin/../";

use VMware::VIRuntime;

$Util::script_version = "1.0";

my %opts = (
   'vmname' => {
      type => "=s",
      help => "The name of the virtual machine",
      required => 0,
   },
   'dsname' => {
      type => "=s",
      help => "The name of the datastore",
      required => 0,
   },
);

Opts::add_options(%opts);
Opts::parse();
Opts::validate();
Util::connect();

my $vmname = Opts::get_option ('vmname');
my $dsname = Opts::get_option ('dsname');

if ($vmname) {
  &get_moid(
    view_type=>'VirtualMachine',
    mo_name=>$vmname,
  );
}

if ($dsname) {
  &get_moid(
    view_type=>'Datastore',
    mo_name=>$dsname,
  );
}

if ( !($vmname) and !($dsname)) {
  print "Select Managed Object. Use --vmname or --dsname\n";
}

Util::disconnect();
exit;

sub get_moid {
   my %params = @_;
   my $vm_moid = 0;
   my $view_type = $params{'view_type'};
   my $mo_name = $params{'mo_name'};

   my $mo_view = Vim::find_entity_view(
                   view_type => $view_type,
                   filter => {
                     'name'=> $mo_name,
                   }
   );

   if ($mo_view) {
     my $moid = $mo_view->get_property('mo_ref')->value;
     print "Manage Object ID: $moid\n";
   } else {
     print "Manage Object doesn't exist\n";
   }
}


