#!/bin/bash

###########################################################################
#                                                                         #
#  Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC). #
#  All rights reserved.                                                   #
#                                                                         #
###########################################################################

#Script to get VM's existence

if [ "$#" -ne 1 ]; then
   echo "Usage:./vmExist.sh <targetVM>"
   exit 1
fi

targetVM=$1

# Set up environment variables
. /export/home/cp/bin/getVars.sh

vm_present=$(/export/home/cp/config/workloads/specvirt/HV_Operations/vSphere/vmExist.pl \
     --server $mgmtServerIP --username $virtUser --password $virtPassword --vmname $targetVM ) 

if [[ $vm_present =~ "exist" ]]
then
   echo "fail"
   else
   echo "pass" 
fi

