#!/bin/sh

# export PATH=./bin:$PATH
# the next line restarts using tclsh \
exec ./bin/tclsh8.6 "$0" ${1+"$@"}

########################################################################
# HammerDB
# Copyright (C) 2003-2018 Steve Shaw
# Author contact information at: http://www.hammerdb.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3 of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with this program; If not, see <https://www.gnu.org/licenses/>
########################################################################
set UserDefaultDir [ file dirname [ info script ] ]
::tcl::tm::path add "$UserDefaultDir/modules"
package require rest
package require huddle

proc wait_for_run_to_complete { runjob } {
global complete
set res [rest::get http://localhost:8080/vucomplete "" ]
set complete [ lindex [rest::format_json $res] 1]
if {!$complete} {
#sleep for 20 seconds and recheck
after 20000 
wait_for_run_to_complete $runjob
	} else {
set res [rest::get http://localhost:8080/vudestroy "" ]
puts "Test Complete"
set jobid [ lindex [ split [ lindex [ lindex [ lindex [rest::format_json $runjob ] 1 ] 1 ] 3 ] \= ] 1 ]
set res [rest::get http://localhost:8080/jobs?jobid=$jobid&result "" ]
puts "Test result: $res"
  }
}

proc wait_for_build_to_complete {} {
global complete
set res [rest::get http://localhost:8080/vucomplete "" ]
set complete [ lindex [rest::format_json $res] 1]
if {!$complete} {
#sleep for 20 seconds and recheck
after 2000 
wait_for_build_to_complete 
	} else {
set res [rest::get http://localhost:8080/vudestroy "" ]
puts "Build Complete"
set complete false
  }
}

proc run_loadedscript_test {} {

puts "destroying users"
set res [rest::get http://localhost:8080/vudestroy "" ]
puts "Clearscript"
    set res [rest::post http://localhost:8080/clearscript "" ]
puts $res

set customscript "mysqltest.tcl"
set _ED(file) $customscript
if {$_ED(file) == ""} {return}
if {![file readable $_ED(file)]} {
puts "File [$_ED(file)] is not readable."
return
}
if {[catch "open \"$_ED(file)\" r" fd]} {
puts "Error while opening $_ED(file): [$fd]"
} else {
set _ED(package) "[read $fd]"
close $fd
}
set huddleobj [ huddle compile {string} "$_ED(package)" ]
set jsonobj [ huddle jsondump $huddleobj ]
set body [ subst { {"script": $jsonobj}} ]
puts "script contents:"
puts $body
set res [ rest::post http://localhost:8080/customscript $body ] 

puts "Creating Virtual Users"
 set res [rest::post http://localhost:8080/vucreate "" ]
puts $res
puts "Running Virtual Users"
 set res [rest::post http://localhost:8080/vurun "" ]
puts $res
wait_for_run_to_complete $res
}

proc run_test {} {
puts "Clearscript"
    set res [rest::post http://localhost:8080/clearscript "" ]
puts $res
puts "Setting Db values"
set body { "db": "mysql" }
    set res [ rest::post http://localhost:8080/dbset $body ] 
set body { "bm": "TPC-C" }
    set res [ rest::post http://localhost:8080/dbset $body ] 
puts "Destorying any old VUs"
    set res [ rest::post http://localhost:8080/vudestroy "" ] 
set body { "vu": "200" }
    set res [ rest::post http://localhost:8080/vuset $body ] 
puts $res
puts "Configuring VUs"
set body { "delay": "250" }
    set res [ rest::post http://localhost:8080/vuset $body ] 
puts $res
set body { "logtotemp": "1" }
    set res [ rest::post http://localhost:8080/vuset $body ] 
puts $res
set body { "showoutput": "1" }
    set res [ rest::post http://localhost:8080/vuset $body ] 
puts $res
set body { "delay": "250" }
    set res [ rest::post http://localhost:8080/vuset $body ] 
puts $res

puts "Setting Dict Values"
set body { "dict": "connection", "key": "mysql_host", "value": "svdc-t016-hdb" }
    set res [rest::post http://localhost:8080/diset $body ]
set body { "dict": "connection", "key": "mysql_port", "value": "3306" }
    set res [rest::post http://localhost:8080/diset $body ]
set body { "dict": "tpcc", "key": "mysql_driver", "value": "timed" }
    set res [rest::post http://localhost:8080/diset $body ]
set body { "dict": "tpcc", "key": "mysql_rampup", "value": "2" }
    set res [rest::post http://localhost:8080/diset $body ]
set body { "dict": "tpcc", "key": "mysql_duration", "value": "124" }
    set res [rest::post http://localhost:8080/diset $body ]
set body { "dict": "tpcc", "key": "mysql_keyandthink", "value": "true" }
    set res [rest::post http://localhost:8080/diset $body ]
puts "Config"
set res [rest::get http://localhost:8080/dict "" ]
puts $res
puts "Loadscript"
    set res [rest::post http://localhost:8080/loadscript "" ]
puts $res
puts "MySQL settings"
    set res [rest::post http://localhost:8080/datagen "" ]
puts $res
puts "VU config (vuconf)"
    set res [rest::post http://localhost:8080/vuconf "" ]
puts $res
#puts "Script in TEXT format"
#    set res [rest::format_json $res]
#puts $res
puts "Create VU"
 set res [rest::post http://localhost:8080/vucreate "" ]
puts "VU info"
 set res [rest::post http://localhost:8080/vucreated "" ]
puts "VU status"
 set res [rest::post http://localhost:8080/vustatus "" ]
puts $res
puts "Run VU"
 set res [rest::post http://localhost:8080/vurun "" ]
puts $res
wait_for_run_to_complete $res
}

proc run_build {} {
puts "running build"
set body { "db": "mysql" }
    set res [ rest::post http://localhost:8080/dbset $body ] 
set body { "bm": "TPC-C" }
    set res [ rest::post http://localhost:8080/dbset $body ] 
puts "Setting Dict Values"
set body { "dict": "connection", "key": "mysql_host", "value": "127.0.0.1" }
    set res [rest::post http://localhost:8080/diset $body ]
set body { "dict": "connection", "key": "mysql_port", "value": "3306" }
    set res [rest::post http://localhost:8080/diset $body ]
set body { "dict": "tpcc", "key": "mysql_count_ware", "value": "250" }
    set res [rest::post http://localhost:8080/diset $body ]
set body { "dict": "tpcc", "key": "mysql_papartition", "value": "true" }
    set res [rest::post http://localhost:8080/diset $body ]
set body { "dict": "tpcc", "key": "mysql_num_vu", "value": "4" }
    set res [rest::post http://localhost:8080/diset $body ]
set body { "dict": "tpcc", "key": "mysql_storage_engine", "value": "innodb" }
    set res [rest::post http://localhost:8080/diset $body ]
puts "Starting Schema Build"
    set res [rest::post http://localhost:8080/buildschema "" ]
puts $res
wait_for_build_to_complete
	}
run_test
