#!/bin/bash

###########################################################################
#                                                                         #
#  SPECvirt Datacenter 2021                                               #
#                                                                         #
#  Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC). #
#  All rights reserved.                                                   #
#                                                                         #
###########################################################################

# AddVMDisk.sh - add disk to VM

if [ "$#" -lt 1 ]; then
  echo "Usage: ./AddVMDisk.sh [target VM] <size in GB> "
  exit 1
fi

if [ "$#" -eq 1 ]; then
  targetVM="svdc-director"
  disksizeGB=$1
else
  targetVM=$1
  disksizeGB=$2
fi

# Set up environment variables
. /export/home/cp/bin/getVars.sh
SCRIPT_LOG_FILE=/export/home/cp/log/${virtVendor}_scripts.log

# Clean up /etc/fstab if needed
if [[ $targetVM == *“svdc-director”* ]]; then
   sed -i ‘/datastore/,$d’ /etc/fstab
fi

ping -q -c 1 $mgmtServerIP > /dev/null
if [ $? -ne 0 ]; then
  echo; echo $(date -u) "  ** Can't reach management network. Check access to the management server. "; echo
  exit 1
fi

cd /export/home/cp/config/workloads/specvirt/HV_Operations/${virtVendor}

pwsh ./addVMDisk.ps1 ${targetVM} ${disksizeGB}
if [ $? -ne 0 ]; then
  echo; echo $(date -u) "  ** Could not create additional disk. Check access to  "
  echo "  ** the management server network, then rerun this script. Exiting."; echo
  exit 1
else
echo $(date -u) "Added disk to $targetVM" |& tee -a $SCRIPT_LOG_FILE
fi

