#!/bin/bash

###################################################################################
#
# SPECvirt Datacenter 2021
#
# Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC)
# All rights reserved.
#
####################################################################################

# DeployVM-AIO.sh - script to deploy workload VMs from template and power them on 
# $1 = targetVM
# $2 = macAddress

if [ "$#" -ne 2 ]; then
   echo "Usage:  ./DeployVM-AIO.sh <targetVM> <mac address>"
   exit 1
fi

vm_present="fail"
retry=0

# Set up environment variables
. /export/home/cp/bin/getVars.sh
SCRIPT_LOG_FILE=/export/home/cp/log/${virtVendor}_scripts.log

targetVM=$1
macAddress=$2

while [[ $vm_present != "pass" ]]
do
   echo $(date -u) "DeployVM script for ${targetVM} started." |& tee -a $SCRIPT_LOG_FILE
   #echo "__mailStoragePool = ${mailStoragePool[${poolIndex}]} __"
   if [[ $targetVM == *"mail"* ]]; then
       tilenum=`expr substr ${1} 7 3`
       numPools=`expr $mailLastPool + 1`
       tileIndex=`expr $tilenum + $numPools - 1`
       poolIndex=`expr $tileIndex % $numPools`
       mailStoragePool=${mailStoragePool[${poolIndex}]}
       AIOstoragePool=$mailStoragePool
   elif [[ $targetVM == *"web"* ]]; then
       tilenum=`expr substr ${1} 7 3`
       numPools=`expr $webLastPool + 1`
       tileIndex=`expr $tilenum + $numPools - 1`
       poolIndex=`expr $tileIndex % $numPools`
       webStoragePool=${webStoragePool[${poolIndex}]}
       AIOstoragePool=$webStoragePool
   elif [[ $targetVM == *"collab"* ]]; then
       tilenum=`expr substr ${1} 7 3`
       numPools=`expr $collabLastPool + 1`
       tileIndex=`expr $tilenum + $numPools - 1`
       poolIndex=`expr $tileIndex % $numPools`
       collabStoragePool=${collabStoragePool[${poolIndex}]}
       AIOstoragePool=$collabStoragePool
   fi

   echo $(date -u) "Storage Pool ${AIOstoragePool} used" |& tee -a $SCRIPT_LOG_FILE
   echo $(date -u) "Deploying $targetVM on Cluster $cluster" |& tee -a $SCRIPT_LOG_FILE
   
   pwsh ./deployVM-Any.ps1 $macAddress $targetVM 8 $vCpuAIO $AIOstoragePool $cluster 2>&1 |& tee -a $SCRIPT_LOG_FILE

   vm_present=$(./vmExist.sh $targetVM)
   if [[ $vm_present != "pass" ]]
   then
      if [ $retry -ge 5 ]
      then
        echo $(date -u) "Deployment of ${targetVM} failed. Exiting script" |& tee -a $SCRIPT_LOG_FILE
      exit 1
    fi
    echo $(date -u) "VM ${targetVM} failed to deploy. Sleeping for 15 seconds and retrying." |& tee -a $SCRIPT_LOG_FILE
    sleep 15
    echo $(date -u) "Redeploying " $targetVM |& tee -a $SCRIPT_LOG_FILE
    retry=`expr $retry + 1`
  fi
done

if [[ $targetVM == *"mail"* ]]
then
   ./AddVMDisk.sh $targetVM 10  |& tee -a $SCRIPT_LOG_FILE

elif [[ $targetVM == *"web"* ]]; then
   ./AddVMDisk.sh $targetVM 20 |& tee -a $SCRIPT_LOG_FILE 

elif [[ $targetVM == *"collab"* ]]; then
   ./AddVMDisk.sh $targetVM 10  |& tee -a $SCRIPT_LOG_FILE
fi

./PowerOnVM.sh ${targetVM} 

echo "$(date -u) DeployVM-AIO script for ${targetVM} finished." |& tee -a $SCRIPT_LOG_FILE

