#!/bin/bash

###########################################################################
#
#  SPECvirt Datacenter 2021
#                                                                         
#  Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC). 
#  All rights reserved.                                                   
#                                                                         
###########################################################################

# DeployVM-BB.sh - use to deploy the BigBench VMs for a tile

if [ "$#" -ne 1 ]; then
   echo "Usage:  ./DeployVM-BB.sh <Tile# to deploy>"
   exit 1
fi

# Set up environment variables
. /export/home/cp/bin/getVars.sh
SCRIPT_LOG_FILE=/export/home/cp/log/${virtVendor}_scripts.log

generateMACs()
{
  zpt=`printf "%04d" $tilenum`
  tileMAC=${zpt:0:2}:${zpt:2:2}

  mac=(${MACAddressPrefix}${tileMAC}":08" ${MACAddressPrefix}${tileMAC}":09" ${MACAddressPrefix}${tileMAC}":10" ${MACAddressPrefix}${tileMAC}":11" ${MACAddressPrefix}${tileMAC}":12" ${MACAddressPrefix}${tileMAC}":13")
}

tilenum=$1
zpt3=`printf "%03d" $tilenum`
targetVM=(svdc-t${zpt3}-bbnn svdc-t${zpt3}-bbdn1 svdc-t${zpt3}-bbdn2 svdc-t${zpt3}-bbdn3 svdc-t${zpt3}-bbdn4 svdc-t${zpt3}-bbdb)
generateMACs

# Check if VMs already exist
vm_exists=$(/export/home/cp/config/workloads/specvirt/HV_Operations/PowerCLI/vmExist.sh svdc-t${zpt3}-bbnn)
if [ $vm_exists = "pass" ]
then
   echo $(date -u) "{svdc-t${zpt3}-bbnn} already exists. Exiting script." |& tee -a $SCRIPT_LOG_FILE
   exit 0 
fi

echo $(date -u) "DeployVM-BB script for ${targetVM} started." |& tee -a $SCRIPT_LOG_FILE

numPools=`expr $BBLastPool + 1`
tileIndex=`expr $tilenum + $numPools - 1`
poolIndex=`expr $tileIndex % $numPools`
BBstoragePool=${BBstoragePool[${poolIndex}]}
echo $(date -u) "Using ${BBstoragePool} " |& tee -a $SCRIPT_LOG_FILE

for i in "${!targetVM[@]}"; do
  echo $(date -u) Deploying "${targetVM[$i]}" at MAC address "${mac[$i]}"; echo

  if [ $i -eq 0 ]; then
     vm_present=`pwsh ./deployVM-Any.ps1 "${mac[$i]}" "${targetVM[$i]}" 8 $vCpuBBnn $BBstoragePool $cluster > /tmp/tmp.$targetVM  2>&1`
     ./PowerOnVM.sh ${targetVM[$i]} 
  fi

  if [ $i -ne 0 ] && [ $i -ne 5 ]; then
     vm_present=`pwsh ./deployVM-Any.ps1 "${mac[$i]}" "${targetVM[$i]}" 24 $vCpuBBdn $BBstoragePool $cluster > /tmp/tmp.$targetVM  2>&1`
     ./PowerOnVM.sh ${targetVM[$i]}
  fi

  if [ $i -eq 5 ]; then
     vm_present=`pwsh ./deployVM-Any.ps1 "${mac[$i]}" "${targetVM[$i]}" 4 $vCpuBBdb $BBstoragePool $cluster > /tmp/tmp.$targetVM  2>&1`
     ./PowerOnVM.sh ${targetVM[$i]}
  fi

  cat /tmp/tmp.$targetVM >>  $SCRIPT_LOG_FILE
  vm_present=`tail -1 /tmp/tmp.$targetVM`
  echo $(date -u) "$vm_present"
  echo "$(date -u) Deployment of ${targetVM[$i]} finished" |& tee -a $SCRIPT_LOG_FILE
  rm -rf /tmp/tmp.$targetVM
done

# Add data disk is in deployVM-Any.ps1

echo $(date -u) "DeployVM-BB script finished." |& tee -a $SCRIPT_LOG_FILE
