#!/bin/bash

###########################################################################
#
#  SPECvirt Datacenter 2021
#                                                                         
#  Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC). 
#  All rights reserved.                                                   
#                                                                         
###########################################################################

# DeployVM-Client.sh - Deploys a client to a client cluster with correct 
#   vCPU, memory, and MAC address settings
#

if [ "$#" -ne 1 ]; then
   echo "Usage:  ./DeployClient.sh <Tile# to deploy>"
   exit 1
fi

# Set up environment variables
. /export/home/cp/bin/getVars.sh
LOG_FILE=/export/home/cp/log/${virtVendor}_scripts.log

generateMACs()
{
  zpt=`printf "%04d" $tilenum`
  tileMAC=${zpt:0:2}:${zpt:2:2}
  macAddress=(${MACAddressPrefix}${tileMAC}":20")
}

tilenum=$1
generateMACs
zpt3=`printf "%03d" $tilenum`

numPools=`expr $clientLastPool + 1`
tileIndex=`expr $tilenum + $numPools - 1`
poolIndex=`expr $tileIndex % $numPools`
clientStoragePool=${clientStoragePool[${poolIndex}]}

targetVM="svdc-t$zpt3-client"

echo $(date -u) "Deploying $targetVM on cluster $clientCluster to storage pool $clientStoragePool" |& tee -a $LOG_FILE
vm_present="incomplete"
vm_present=`pwsh ./deployVM-Any.ps1 $macAddress $targetVM 8 $vCpuClient $clientStoragePool $clientCluster > /tmp/tmp.$targetVM  2>&1`
cat /tmp/tmp.$targetVM >> $LOG_FILE
vm_present="`tail -1 /tmp/tmp.$targetVM`"
echo $(date -u) "$vm_present"
rm -rf /tmp/tmp.$targetVM

./PowerOnVM.sh ${targetVM} 

echo "$(date -u) DeployVM script for ${targetVM} finished." |& tee -a $LOG_FILE

