#!/bin/bash

###########################################################################
#
#  SPECvirt Datacenter 2021
#                                                                         
#  Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC). 
#  All rights reserved.                                                   
#                                                                         
###########################################################################

# DeployVM-ClientToHost.sh - deploys a client with correct vCPU, memory, and 
#      MAC address settings to a host
#

if [ "$#" -ne 3 ]; then
   echo "Usage:  ./DeployVM-ClientToHost.sh <tilenum> <host name> <client storagepool>"
   exit 1
fi

# Set up environment variables
. /export/home/cp/bin/getVars.sh
LOG_FILE=/export/home/cp/log/${virtVendor}_scripts.log

tilenum=$1
hostName=$2
storagePool=$3

cd /export/home/cp/config/workloads/specvirt/HV_Operations/${virtVendor}

generateMACs()
{
  zpt=`printf "%04d" $tilenum`
  tileMAC=${zpt:0:2}:${zpt:2:2}
  macAddress=(${MACAddressPrefix}${tileMAC}":20")
}

tilenum=$1
generateMACs
zpt3=`printf "%03d" $tilenum`
targetVM="svdc-t$zpt3-client"

echo $(date -u) "Deploying $targetVM on host $hostName to storage pool $storagePool" |& tee -a $LOG_FILE
vm_present="incomplete"
vm_present=`pwsh ./deployVM-ClientToHost.ps1 $macAddress $targetVM 8 $vCpuClient $storagePool $hostName > /tmp/tmp.$targetVM  2>&1`
cat /tmp/tmp.$targetVM >> $LOG_FILE
vm_present="`tail -1 /tmp/tmp.$targetVM`"
echo $(date -u) "$vm_present"

if [[ $vmdeploy =~ "not found" ]]
then
   echo $(date -u) "ERROR: Host name doesn't exist. Retry with valid host name." ; echo |& tee -a $LOG_FILE
   exit 1
elif [[ $vmdeploy =~ "not available" ]]
then
   echo $(date -u) "ERROR: Storage pool doesn't exist. Retry with valid storage pool." ; echo |& tee -a $LOG_FILE
   exit 1
fi

./PowerOnVM.sh ${targetVM} 

echo $(date -u) Deployed $targetVM |& tee -a $SCRIPT_LOG_FILE

