#!/bin/bash

###########################################################################
#
#  SPECvirt Datacenter 2021
#                                                                         
#  Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC). 
#  All rights reserved.                                                   
#                                                                         
###########################################################################

# DeployVM-HDB.sh - use to deploy the HammerDB VMs for a tile

if [ "$#" -ne 1 ]; then
   echo "Usage:  ./DeployVM-HDB.sh <Tile# to deploy>"
   exit 1
fi

# Set up environment variables
. /export/home/cp/bin/getVars.sh
SCRIPT_LOG_FILE=/export/home/cp/log/${virtVendor}_scripts.log

generateMACs()
{
  zpt=`printf "%04d" $tilenum`
  tileMAC=${zpt:0:2}:${zpt:2:2}
  mac=(${MACAddressPrefix}${tileMAC}":06" ${MACAddressPrefix}${tileMAC}":07")
}

tilenum=$1
generateMACs
zpt3=`printf "%03d" $tilenum`

numPools=`expr $HDBLastPool + 1`
tileIndex=`expr $tilenum + $numPools - 1`
poolIndex=`expr $tileIndex % $numPools`
HDBstoragePool=${HDBstoragePool[${poolIndex}]}
echo $(date -u) "Storage Pool ${HDBstoragePool} used" |& tee -a $SCRIPT_LOG_FILE

targetVM="svdc-t$zpt3-happ"
echo $(date -u) Deploying "svdc-t$zpt3-happ" at MAC address "${mac[1]}" |& tee -a $SCRIPT_LOG_FILE
vm_present=`pwsh ./deployVM-Any.ps1 "${mac[1]}" "${targetVM}" 8 $vCpuHapp $HDBstoragePool $cluster  > /tmp/tmp.$targetVM  2>&1`
./PowerOnVM.sh ${targetVM} 

cat /tmp/tmp.$targetVM >>  $SCRIPT_LOG_FILE
vm_present="`tail -1 /tmp/tmp.$targetVM`"
echo $(date -u) "$vm_present"
rm -rf /tmp/tmp.$targetVM
echo "$(date -u) Deployment of ${targetVM} finished" |& tee -a $SCRIPT_LOG_FILE

# 50GB disk added in PWSH deployVM-Any.ps1
targetVM="svdc-t$zpt3-hdb"
echo $(date -u) Deploying "svdc-t$zpt3-hdb" at MAC address "${mac[0]}" |& tee -a $SCRIPT_LOG_FILE
vm_present=`pwsh ./deployVM-Any.ps1 "${mac[0]}" "${targetVM}" 8 $vCpuHdb $HDBstoragePool $cluster > /tmp/tmp.$targetVM  2>&1`
./PowerOnVM.sh ${targetVM} 

cat /tmp/tmp.$targetVM >>  $SCRIPT_LOG_FILE
vm_present="`tail -1 /tmp/tmp.$targetVM`"
#echo $(date -u) "$vm_present"
echo "$(date -u) Deployment of ${targetVM} finished" |& tee -a $SCRIPT_LOG_FILE
