#!/bin/bash

#############################################################################
#
# SPECvirt Datacenter 2021
#
# Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC)
# All rights reserved.
#
##############################################################################

# EnterMaintenanceMode.sh - puts vSphere host in maintenance mode to "remove" it from the cluster

if [ "$#" -ne 1 ]; then
   echo "Usage:  ./EnterMaintenanceMode.sh <offlineHost>"
   exit 1
fi

# Set up environment variables
. /export/home/cp/bin/getVars.sh
SCRIPT_LOG_FILE=/export/home/cp/log/${virtVendor}_scripts.log

offlineHost=$1

echo; echo $(date -u) "Entering maintenance mode on $offlineHost" |& tee -a $SCRIPT_LOG_FILE
  pwsh ./enterMaintenanceMode.ps1 $offlineHost
echo $(date -u) "$offlineHost entered maintenance mode" |& tee -a $SCRIPT_LOG_FILE
