#!/bin/bash

#############################################################################
#
# SPECvirt Datacenter 2021
#
# Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC)
# All rights reserved.
#
##############################################################################

# ExitMaintenanceMode.sh - moves vSphere host out of maintenance mode 
#   to "add" it to the cluster

if [ "$#" -ne 1 ]; then
   echo "Usage:  ./ExitMaintenanceMode.sh <offlineHost>"
   exit 1
fi

# Set up environment variables
. /export/home/cp/bin/getVars.sh
SCRIPT_LOG_FILE=/export/home/cp/log/${virtVendor}_scripts.log

offlineHost=$1

echo; echo $(date -u) "Exiting maintenance mode on $offlineHost" |& tee -a $SCRIPT_LOG_FILE
  pwsh ./exitMaintenanceMode.ps1 $offlineHost
echo $(date -u) "$offlineHost exited maintenance mode"|& tee -a $SCRIPT_LOG_FILE

