#!/bin/bash

##################################################################################
#
# SPECvirt Datacenter 2021
#
# Copyright (c) 2021, 2022 Standard Performance Evaluation Corporation (SPEC)
# All rights reserved.
#
##################################################################################

# Install-PowerCLI-SDK.sh - Script to install Microsoft PowerShell, VMware PowerCLI, 
#   and VMware PowerCLI SDK for SPECvirt Datacenter 2021

alias cp='cp'
current=`date -u`
export CP_POWERCLI=/export/home/cp/config/workloads/specvirt/HV_Operations/PowerCLI; export cp_powercli=$CP_POWERCLI

# Get and set variables from Control.config
. /export/home/cp/bin/getVars.sh
SCRIPT_LOG_FILE=/export/home/cp/log/VMware-PowerCLI-SDK-install.log
rm -rf $SCRIPT_LOG_FILE
echo; echo $(date -u) "***  Starting installation script" |& tee -a $SCRIPT_LOG_FILE

backup_files () 
{
echo $(date -u) "***  Backing up edited files " |& tee -a $SCRIPT_LOG_FILE
targetdir=/export/home/cp/config/workloads/specvirt/HV_Operations/PowerCLI/backup
mkdir -p $targetdir |& tee -a $SCRIPT_LOG_FILE
cp /root/.bashrc $targetdir |& tee -a $SCRIPT_LOG_FILE
cp /export/home/cp/bin/Control.config $targetdir |& tee -a $SCRIPT_LOG_FILE

if [[ $? -ne 1 ]] ; then 
   echo; echo $(date -u) "***  Configuration files backed up to $targetdir. Continuing..." |& tee -a $SCRIPT_LOG_FILE
fi
}

restore_files ()
{
echo; echo $(date -u) "********  Restoring settings and removing installed packages" |& tee -a $SCRIPT_LOG_FILE
cp $targetdir/.bashrc /root |& tee -a $SCRIPT_LOG_FILE
cp $targetdir/Control.config /export/home/cp/bin |& tee -a $SCRIPT_LOG_FILE
rpm -e powershell-lts > /dev/null |& tee -a $SCRIPT_LOG_FILE 
rm -rf /opt/microsoft/powershell/7-lts > /dev/null |& tee -a $SCRIPT_LOG_FILE

echo $(date -u) "********  Configuration restored. See the README and $CP_LOG/$SCRIPT_LOG_FILE for details." |& tee -a $SCRIPT_LOG_FILE
echo "********  To report problems, visit the SPECvirt Datacenter 2021 support forum at " |& tee -a $SCRIPT_LOG_FILE
echo "********  https://www.spec.org/forums/index.php?board=7.0 SPECvirt Datacenter 2021 support forum" |& tee -a $SCRIPT_LOG_FILE
echo "********  Exit." |& tee -a $SCRIPT_LOG_FILE
echo; read -p "Press any key to exit "
}

do_pwsh ()
{
echo; echo $(date -u) "***  Installing Microsoft PowerShell" |& tee -a $SCRIPT_LOG_FILE
cd /export/home/cp/config/workloads/specvirt/HV_Operations/PowerCLI/pkgs
installpwsh=`rpm -ivh powershell-lts-7.2.2-1.rh.x86_64.rpm` > /dev/null
if [[ $? -ne 0 ]] ; then
   echo; echo $(date -u) "********  ERROR: Microsoft PowerShell not installed. Check with SPECvirt support. " |& tee -a $SCRIPT_LOG_FILE
   echo "********  Cleaning up and restoring original configuration." |& tee -a $SCRIPT_LOG_FILE
   restore_files |& tee -a $SCRIPT_LOG_FILE
else
   echo; echo $(date -u) "***  Microsoft PowerShell installed. Continuing... " |& tee -a $SCRIPT_LOG_FILE
fi
}

do_pcli ()
{
echo; echo $(date -u) "***  Installing VMware PowerCLI. Ignore any warnings." |& tee -a $SCRIPT_LOG_FILE
cd /opt/microsoft/powershell/7-lts/Modules
unzip -q /export/home/cp/config/workloads/specvirt/HV_Operations/PowerCLI/pkgs/VMware-PowerCLI-12.6.0-19610541.zip 
installpcli=`pwsh /export/home/cp/config/workloads/specvirt/HV_Operations/PowerCLI/install-VMware-PowerCLI.ps1`
checkfiles=`du -a | grep VMware | wc | awk '{ print $1}'`
if [[ $checkfiles -ne 2067 ]] ; then
    echo; echo $(date -u) "********  ERROR: VMware PowerCLI not installed. Check with SPECvirt support." |& tee -a $SCRIPT_LOG_FILE
    echo "********  Cleaning up and restoring original configuration." |& tee -a $SCRIPT_LOG_FILE
    restore_files |& tee -a $SCRIPT_LOG_FILE
else
    echo; echo $(date -u) "***  VMware PowerCLI and hypervisor scripts installed. " |& tee -a $SCRIPT_LOG_FILE
fi
}

set_env ()
{
    echo $(date -u) "***  Changing environment variables to use PowerCLI" |& tee -a $SCRIPT_LOG_FILE
    sed -i 's/vSphere or RHV/vSphere or RHV or PowerCLI/' /export/home/cp/bin/Control.config |& tee -a $SCRIPT_LOG_FILE
    sed -i 's/^virtVendor/#virtVendor/' /export/home/cp/bin/Control.config |& tee -a $SCRIPT_LOG_FILE
    sed -i '/^#virtVendor/a virtVendor = PowerCLI' /export/home/cp/bin/Control.config |& tee -a $SCRIPT_LOG_FILE
    sed -i 's/ *$//' /export/home/cp/bin/Control.config 
    echo 'export CP_POWERCLI=/export/home/cp/config/workloads/specvirt/HV_Operations/PowerCLI; export cp_powercli=$CP_POWERCLI' >> /root/.bashrc |& tee -a $SCRIPT_LOG_FILE

   if ( grep -Fq "PowerCLI" /export/home/cp/bin/Control.config ) && ( grep -Fq POWERCLI /root/.bashrc ); then
      echo; echo $(date -u) "***  Enviroment variables are set to use PowerCLI. " |& tee -a $SCRIPT_LOG_FILE
   else
      echo $(date -u) "********  ERROR: Environment variables not set. Check with SPECvirt support." |& tee -a $SCRIPT_LOG_FILE
      restore_files |& tee -a $SCRIPT_LOG_FILE
   fi
}

main ()
{
echo; echo "**************************************************************************************"
echo "**                                                                                  ** "
echo "**    This script installs Microsoft PowerShell, VMware PowerCLI, and the           ** "
echo "**    VMware PowerCLI for SPECvirt Datacenter 2021 SDK.                             ** "
echo "**                                                                                  ** "
echo "**    This script automatically logs out the user. Log in again to use the          ** "
echo "**    correct environment variables.                                                ** "
echo "**                                                                                  ** "
echo "**************************************************************************************"
echo
while true; do
    read -p "***  Proceed with installation? [y/n] " yn
    case $yn in
        [Yy]* ) echo; echo "***  Proceeding..."; break;;
        [Nn]* ) echo "********  Cancelling installation. Exit."; echo; exit;;
        * ) echo "Please answer y or n.";;
    esac
done

echo; echo $(date -u) "***  Log for this script is located at $SCRIPT_LOG_FILE" ; echo

chown -R root:root /export/home/cp/config/workloads/specvirt/HV_Operations/PowerCLI

backup_files
do_pwsh
do_pcli
set_env
}

main

echo; echo $(date -u) "***  Success! VMware PowerCLI SDK and required components installed. " |& tee -a $SCRIPT_LOG_FILE
read -p "*** Reboot this VM manually. Press any key to exit "
