#!/bin/bash

#############################################################################
#
# SPECvirt Datacenter 2021
#
# Copyright (c) 2021 Standard Performance Evaluation Corporation (SPEC)
# All rights reserved.
#
##############################################################################

# PowerOffAllTiles.sh - powers off all workload VMs on the SUT cluster
#
# Note: Calls powerOffAllTiles.ps1 - 
# Uses Stop-VMGuest to gracefully shutdown the VM, then
# waits up to 3 x #VMs seconds and then attempts to PowerOff
# via Stop-VM any VM that had not gracefully shutdown.
# Does not affect clients.
# Used by: prepTestRun.sh
#
# Set up environment variables
. /export/home/cp/bin/getVars.sh
SCRIPT_LOG_FILE=/export/home/cp/log/${virtVendor}_scripts.log

cd /export/home/cp/config/workloads/specvirt/HV_Operations/${virtVendor}

echo $(date -u) "Powering off all workload VMs on cluster $cluster..." |& tee -a $SCRIPT_LOG_FILE
pwsh ./powerOffAllTiles.ps1  >/dev/null

status=$?
if [ $status -eq 0 ] ; then 
 echo $(date -u) "SUCCESS. All workload VMs powered off" |& tee -a $SCRIPT_LOG_FILE
else
 echo $(date -u) "FAILED. $status workload VMs not powered off" |& tee -a $SCRIPT_LOG_FILE
fi
exit $status 
